/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.Collections;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.FmtUtils;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;

public abstract class AbstractFunction
implements Function {
    public void build(String uri, ExprList args) {
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        Node[] nodes = new Node[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            Expr e = args.get(i);
            try {
                NodeValue x;
                if (e == null || e.isVariable() && (!e.isVariable() || binding.get(e.asVar()) == null) || (x = e.eval(binding, env)) == null) continue;
                nodes[i] = x.asNode();
                continue;
            }
            catch (ExprEvalException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Error during function evaluation", ex);
            }
        }
        if (SPINStatisticsManager.get().isRecording() && SPINStatisticsManager.get().isRecordingNativeFunctions()) {
            NodeValue result;
            StringBuffer sb = new StringBuffer();
            sb.append("SPARQL Function ");
            sb.append(SSE.format((Node)NodeFactory.createURI((String)uri), (PrefixMapping)env.getActiveGraph().getPrefixMapping()));
            sb.append("(");
            for (int i = 0; i < nodes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (nodes[i] == null) {
                    sb.append("?arg" + (i + 1));
                    continue;
                }
                sb.append(SSE.format((Node)nodes[i], (PrefixMapping)env.getActiveGraph().getPrefixMapping()));
            }
            sb.append(")");
            long startTime = System.currentTimeMillis();
            try {
                result = this.exec(nodes, env);
                sb.append(" = ");
                sb.append(FmtUtils.stringForNode((Node)result.asNode(), (PrefixMapping)env.getActiveGraph().getPrefixMapping()));
            }
            catch (ExprEvalException ex) {
                sb.append(" : ");
                sb.append(ex.getLocalizedMessage());
                throw ex;
            }
            finally {
                long endTime = System.currentTimeMillis();
                SPINStatistics stats = new SPINStatistics(sb.toString(), "(Native built-in function)", endTime - startTime, startTime, NodeFactory.createURI((String)uri));
                SPINStatisticsManager.get().addSilently(Collections.singleton(stats));
            }
            return result;
        }
        return this.exec(nodes, env);
    }

    protected abstract NodeValue exec(Node[] var1, FunctionEnv var2);
}

