/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.topbraid.spin.arq.ARQ2SPIN;
import org.topbraid.spin.arq.FromDataset;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.print.StringPrintContext;
import org.topbraid.spin.model.update.Update;
import org.topbraid.spin.system.ExtraPrefixes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SPINExpressions;

public class ARQFactory {
    private static ARQFactory singleton = new ARQFactory();
    private Map<Node, String> node2String = new ConcurrentHashMap<Node, String>();
    private Map<String, org.apache.jena.query.Query> string2Query = new ConcurrentHashMap<String, org.apache.jena.query.Query>();
    private Map<String, UpdateRequest> string2Update = new ConcurrentHashMap<String, UpdateRequest>();
    private boolean useCaches = true;

    public static ARQFactory get() {
        return singleton;
    }

    public static Model getNamedModel(String graphURI) {
        return ARQFactory.get().getDataset(null).getNamedModel(graphURI);
    }

    public static void set(ARQFactory value) {
        singleton = value;
    }

    protected void adjustQueryExecution(QueryExecution qexec) {
    }

    public void clearCaches() {
        this.node2String.clear();
        this.string2Query.clear();
        this.string2Update.clear();
    }

    public String createCommandString(Command spinCommand) {
        String result = this.node2String.get(spinCommand.asNode());
        if (result == null) {
            String text = ARQ2SPIN.getTextOnly(spinCommand);
            if (text != null) {
                result = ARQFactory.get().createPrefixDeclarations(spinCommand.getModel()) + text;
            } else {
                StringPrintContext p = new StringPrintContext();
                p.setUsePrefixes(false);
                p.setPrintPrefixes(false);
                spinCommand.print(p);
                result = p.getString();
            }
            if (this.useCaches) {
                this.node2String.put(spinCommand.asNode(), result);
            }
        }
        return result;
    }

    public String createExpressionString(RDFNode expression) {
        String result = this.node2String.get(expression.asNode());
        if (result == null) {
            StringPrintContext p = new StringPrintContext();
            p.setUsePrefixes(false);
            SPINExpressions.printExpressionString(p, expression, false, false, expression.getModel().getGraph().getPrefixMapping());
            result = p.getString();
            if (this.useCaches) {
                this.node2String.put(expression.asNode(), result);
            }
        }
        return result;
    }

    public org.apache.jena.query.Query createExpressionQuery(RDFNode expression) {
        String queryString = this.createExpressionString(expression);
        return this.createExpressionQuery(queryString);
    }

    public org.apache.jena.query.Query createExpressionQuery(String expression) {
        org.apache.jena.query.Query result = this.string2Query.get(expression);
        if (result == null) {
            String queryString = "SELECT (" + expression + ") WHERE {}";
            result = this.doCreateQuery(queryString);
            if (this.useCaches) {
                this.string2Query.put(expression, result);
            }
        }
        return result;
    }

    public String createPrefixDeclarations(Model model) {
        return this.createPrefixDeclarations(model, true);
    }

    public String createPrefixDeclarations(Model model, boolean includeExtraPrefixes) {
        StringBuffer queryString = new StringBuffer();
        String defaultNamespace = JenaUtil.getNsPrefixURI(model, "");
        if (defaultNamespace != null) {
            queryString.append("PREFIX :   <" + defaultNamespace + ">\n");
        }
        if (includeExtraPrefixes) {
            Map<String, String> extraPrefixes = ExtraPrefixes.getExtraPrefixes();
            for (String prefix : extraPrefixes.keySet()) {
                String ns = extraPrefixes.get(prefix);
                ARQFactory.perhapsAppend(queryString, prefix, ns, model);
            }
        }
        for (String prefix : model.getNsPrefixMap().keySet()) {
            String namespace = JenaUtil.getNsPrefixURI(model, prefix);
            if (prefix.length() <= 0 || namespace == null) continue;
            queryString.append("PREFIX " + prefix + ": <" + namespace + ">\n");
        }
        return queryString.toString();
    }

    public org.apache.jena.query.Query createQuery(Query spinQuery) {
        String queryString = this.createCommandString(spinQuery);
        return this.createQuery(queryString);
    }

    public org.apache.jena.query.Query createQuery(String queryString) {
        org.apache.jena.query.Query result = this.string2Query.get(queryString);
        if (result == null) {
            result = this.doCreateQuery(queryString);
            if (this.useCaches) {
                this.string2Query.put(queryString, result);
            }
        }
        return result;
    }

    public org.apache.jena.query.Query doCreateQuery(String queryString) {
        return this.doCreateQuery(queryString, null);
    }

    protected org.apache.jena.query.Query doCreateQuery(String queryString, PrefixMapping prefixMapping) {
        org.apache.jena.query.Query query = new org.apache.jena.query.Query();
        if (prefixMapping != null) {
            query.setPrefixMapping(prefixMapping);
        }
        return QueryFactory.parse((org.apache.jena.query.Query)query, (String)queryString, null, (Syntax)this.getSyntax());
    }

    public org.apache.jena.query.Query createQuery(Model model, String partialQuery) {
        PrefixMappingImpl pm = new PrefixMappingImpl();
        String defaultNamespace = JenaUtil.getNsPrefixURI(model, "");
        if (defaultNamespace != null) {
            pm.setNsPrefix("", defaultNamespace);
        }
        Map<String, String> extraPrefixes = ExtraPrefixes.getExtraPrefixes();
        for (String prefix : extraPrefixes.keySet()) {
            String ns = extraPrefixes.get(prefix);
            if (ns == null || pm.getNsPrefixURI(prefix) != null) continue;
            pm.setNsPrefix(prefix, ns);
        }
        for (String prefix : model.getNsPrefixMap().keySet()) {
            String namespace = JenaUtil.getNsPrefixURI(model, prefix);
            if (prefix.length() <= 0 || namespace == null) continue;
            pm.setNsPrefix(prefix, namespace);
        }
        return this.doCreateQuery(partialQuery, (PrefixMapping)pm);
    }

    public QueryExecution createQueryExecution(org.apache.jena.query.Query query, Model model) {
        return this.createQueryExecution(query, model, null);
    }

    public QueryExecution createQueryExecution(org.apache.jena.query.Query query, Model model, QuerySolution initialBinding) {
        Dataset dataset = this.getDataset(model);
        if (dataset != null) {
            return this.createQueryExecution(query, dataset, initialBinding);
        }
        QueryExecution qexec = QueryExecutionFactory.create((org.apache.jena.query.Query)query, (Model)model, (QuerySolution)initialBinding);
        this.adjustQueryExecution(qexec);
        return qexec;
    }

    public QueryExecution createQueryExecution(org.apache.jena.query.Query query, Dataset dataset) {
        return this.createQueryExecution(query, dataset, null);
    }

    public QueryExecution createQueryExecution(org.apache.jena.query.Query query, Dataset dataset, QuerySolution initialBinding) {
        if (!query.getGraphURIs().isEmpty() || !query.getNamedGraphURIs().isEmpty()) {
            dataset = new FromDataset(dataset, query);
        }
        QueryExecution qexec = QueryExecutionFactory.create((org.apache.jena.query.Query)query, (Dataset)dataset, (QuerySolution)initialBinding);
        this.adjustQueryExecution(qexec);
        return qexec;
    }

    public QueryEngineHTTP createRemoteQueryExecution(org.apache.jena.query.Query query) {
        List graphURIs = query.getGraphURIs();
        return this.createRemoteQueryExecution(query, graphURIs);
    }

    public QueryEngineHTTP createRemoteQueryExecution(org.apache.jena.query.Query query, List<String> graphURIs) {
        String service;
        String serviceAsURI = service = graphURIs.get(0);
        if (service.endsWith("/sparql")) {
            serviceAsURI = service.substring(0, service.lastIndexOf(47));
        }
        return this.createRemoteQueryExecution(service, query, Collections.singletonList(serviceAsURI), graphURIs, null, null);
    }

    public QueryEngineHTTP createRemoteQueryExecution(String service, org.apache.jena.query.Query query, List<String> defaultGraphURIs, List<String> namedGraphURIs, String user, char[] password) {
        QueryEngineHTTP qexec = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)service, (org.apache.jena.query.Query)query);
        if (defaultGraphURIs.size() > 0) {
            qexec.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs.size() > 0) {
            qexec.setNamedGraphURIs(namedGraphURIs);
        }
        if (user != null) {
            qexec.setBasicAuthentication(user, password);
        }
        return qexec;
    }

    public UpdateRequest createUpdateRequest(String parsableString) {
        UpdateRequest result = this.string2Update.get(parsableString);
        if (result == null) {
            result = UpdateFactory.create((String)parsableString);
            if (this.useCaches) {
                this.string2Update.put(parsableString, result);
            }
        }
        return result;
    }

    public UpdateRequest createUpdateRequest(Update spinUpdate) {
        String string = this.createCommandString(spinUpdate);
        return this.createUpdateRequest(string);
    }

    public Dataset getDataset(Model defaultModel) {
        return new DatasetImpl(defaultModel);
    }

    public static List<String> getNamedGraphURIs(org.apache.jena.query.Query query) {
        final LinkedList<String> results = new LinkedList<String>();
        ElementWalker.walk((Element)query.getQueryPattern(), (ElementVisitor)new ElementVisitorBase(){

            public void visit(ElementNamedGraph el) {
                String uri;
                Node node = el.getGraphNameNode();
                if (node != null && node.isURI() && !results.contains(uri = node.getURI())) {
                    results.add(uri);
                }
            }
        });
        return results;
    }

    public Syntax getSyntax() {
        return Syntax.syntaxARQ;
    }

    public boolean isUsingCaches() {
        return this.useCaches;
    }

    private static void perhapsAppend(StringBuffer queryString, String prefix, String namespace, Model model) {
        if (model.getNsPrefixURI(prefix) == null && namespace != null) {
            queryString.append("PREFIX ");
            queryString.append(prefix);
            queryString.append(": <");
            queryString.append(namespace);
            queryString.append(">\n");
        }
    }

    public void setUseCaches(boolean value) {
        this.useCaches = value;
    }
}

