/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.sweble.wikitext.lazy.parser.RtData;

public final class TextUtils {
    public static NodeList trim(NodeList nodes) {
        ArrayList<AstNode> result = new ArrayList<AstNode>((Collection<AstNode>)nodes);
        TextUtils.trimLeft(result);
        TextUtils.trimRight(result);
        return new NodeList(result);
    }

    public static NodeList trimLeft(NodeList nodes) {
        ArrayList<AstNode> result = new ArrayList<AstNode>((Collection<AstNode>)nodes);
        TextUtils.trimLeft(result);
        return new NodeList(result);
    }

    public static NodeList trimRight(NodeList nodes) {
        ArrayList<AstNode> result = new ArrayList<AstNode>((Collection<AstNode>)nodes);
        TextUtils.trimRight(result);
        return new NodeList(result);
    }

    public static NodeList trimAndPad(NodeList nodes, int spaces) {
        ArrayList<AstNode> result = new ArrayList<AstNode>((Collection<AstNode>)nodes);
        TextUtils.trimLeft(result);
        TextUtils.trimRight(result);
        if (spaces <= 0) {
            return new NodeList(result);
        }
        return TextUtils.pad(result, spaces);
    }

    public static void trimLeft(ArrayList<AstNode> result) {
        int i = 0;
        block4: while (i < result.size()) {
            switch (result.get(i).getNodeType()) {
                case 4097: {
                    Text stringNode = (Text)result.get(i);
                    String trimmed = TextUtils.trimLeft(stringNode.getContent());
                    if (trimmed == stringNode.getContent()) break block4;
                    if (trimmed.isEmpty()) {
                        result.remove(i);
                        continue block4;
                    }
                    result.set(i, (AstNode)new Text(trimmed));
                    break block4;
                }
                case 458754: {
                    ++i;
                    continue block4;
                }
            }
        }
    }

    public static void trimRight(ArrayList<AstNode> result) {
        int i = result.size() - 1;
        block4: while (i >= 0) {
            switch (result.get(i).getNodeType()) {
                case 4097: {
                    Text stringNode = (Text)result.get(i);
                    String trimmed = TextUtils.trimRight(stringNode.getContent());
                    if (trimmed == stringNode.getContent()) break block4;
                    if (trimmed.isEmpty()) {
                        result.remove(i--);
                        continue block4;
                    }
                    result.set(i, (AstNode)new Text(trimmed));
                    break block4;
                }
                case 458754: {
                    --i;
                    continue block4;
                }
            }
        }
    }

    public static NodeList pad(ArrayList<AstNode> result, int spaces) {
        if (spaces <= 0) {
            return new NodeList(result);
        }
        if (result.isEmpty()) {
            result.add((AstNode)new Text(StringUtils.strrep((char)' ', (int)(spaces * 2))));
        } else {
            String spacesString = StringUtils.strrep((char)' ', (int)spaces);
            Text before = null;
            if (result.get(0).isNodeType(4097)) {
                before = (Text)result.remove(0);
            }
            String spaced = "";
            if (before != null) {
                spaced = before.getContent();
            }
            spaced = spacesString + spaced;
            result.add(0, (AstNode)new Text(spaced));
            Text after = null;
            int i = result.size() - 1;
            if (result.get(i).isNodeType(4097)) {
                after = (Text)result.remove(i);
            }
            spaced = "";
            if (after != null) {
                spaced = after.getContent();
            }
            spaced = spaced + spacesString;
            result.add((AstNode)new Text(spaced));
        }
        return new NodeList(result);
    }

    public static String trim(String text) {
        int from;
        int length = text.length();
        for (from = 0; from < length && Character.isWhitespace(text.charAt(from)); ++from) {
        }
        while (from < length && Character.isWhitespace(text.charAt(length - 1))) {
            --length;
        }
        if (from > 0 || length < text.length()) {
            return text.substring(from, length);
        }
        return text;
    }

    public static String trimLeft(String text) {
        int from;
        int length = text.length();
        for (from = 0; from < length && Character.isWhitespace(text.charAt(from)); ++from) {
        }
        if (from > 0) {
            return text.substring(from, length);
        }
        return text;
    }

    public static String trimRight(String text) {
        int length;
        for (length = text.length(); 0 < length && Character.isWhitespace(text.charAt(length - 1)); --length) {
        }
        if (length < text.length()) {
            return text.substring(0, length);
        }
        return text;
    }

    public static RtData addRtData(AstNode yyValue, Object[] ... rts) {
        if (rts.length != yyValue.size() + 1) {
            rts = (Object[][])Arrays.copyOf(rts, yyValue.size() + 1);
        }
        RtData data = new RtData(rts);
        yyValue.setAttribute("RTD", (Object)data);
        return data;
    }

    public static Object[] joinRt(Object ... objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        block4: for (Object o : objects) {
            if (o instanceof AstNode) {
                AstNode a = (AstNode)o;
                switch (a.getNodeType()) {
                    case 2: {
                        for (AstNode c : (NodeList)a) {
                            if (c.getNodeType() == 4097) {
                                TextUtils.rtAddString(result, ((Text)c).getContent());
                                continue;
                            }
                            result.add(c);
                        }
                        continue block4;
                    }
                    case 4097: {
                        TextUtils.rtAddString(result, ((Text)a).getContent());
                        break;
                    }
                    default: {
                        result.add(a);
                    }
                }
                continue;
            }
            if (o == null) continue;
            if (o instanceof Character) {
                TextUtils.rtAddString(result, String.valueOf((Character)o));
                continue;
            }
            TextUtils.rtAddString(result, (String)o);
        }
        return result.toArray();
    }

    public static void rtAddString(ArrayList<Object> result, String so) {
        int last = result.size() - 1;
        if (last >= 0 && result.get(last) instanceof String) {
            result.set(last, result.get(last) + so);
        } else {
            result.add(so);
        }
    }

    public static void prependRtData(AstNode n, String data) {
        RtData rtd = (RtData)n.getAttribute("RTD");
        if (rtd == null || rtd.getRts().length == 0) {
            TextUtils.addRtData(n, new Object[][]{TextUtils.joinRt(data)});
        } else {
            Object[] rtd0 = rtd.getRts()[0];
            if (rtd0 == null || rtd0.length == 0) {
                rtd0 = new Object[]{data};
            } else if (rtd0[0] instanceof String) {
                rtd0 = (Object[])rtd0.clone();
                rtd0[0] = data + rtd0[0];
            } else {
                Object[] rtd0_ = new Object[rtd0.length + 1];
                rtd0_[0] = data;
                System.arraycopy(rtd0, 0, rtd0_, 1, rtd0.length);
            }
            Object[][] rts = (Object[][])rtd.getRts().clone();
            rts[0] = rtd0;
            n.setAttribute("RTD", (Object)new RtData(rts));
        }
    }
}

