/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.StringContentNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.sweble.wikitext.lazy.parser.RtData;

public class RtWikitextPrinter {
    private PrintWriter w;

    public RtWikitextPrinter(Writer writer) {
        this.w = new PrintWriter(writer);
    }

    public static String print(AstNode node) {
        StringWriter writer = new StringWriter();
        new RtWikitextPrinter(writer).go(node);
        return writer.toString();
    }

    public static Writer print(Writer writer, AstNode node) {
        new RtWikitextPrinter(writer).go(node);
        return writer;
    }

    private void go(AstNode node) {
        switch (node.getNodeType()) {
            case 2: {
                for (AstNode c : (NodeList)node) {
                    this.go(c);
                }
                break;
            }
            case 4097: {
                this.w.print(((StringContentNode)node).getContent());
                break;
            }
            default: {
                RtData rtd = (RtData)node.getAttribute("RTD");
                if (rtd != null) {
                    int i = 0;
                    for (AstNode n : node) {
                        this.printRtd(rtd.getRts()[i++]);
                        if (n == null) continue;
                        this.go(n);
                    }
                    this.printRtd(rtd.getRts()[i]);
                    break;
                }
                for (AstNode n : node) {
                    if (n == null) continue;
                    this.go(n);
                }
            }
        }
    }

    private void printRtd(Object[] objects) {
        if (objects != null) {
            for (Object o : objects) {
                if (o instanceof AstNode) {
                    this.go((AstNode)o);
                    continue;
                }
                this.w.print(o);
            }
        }
    }
}

