/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.postprocessor;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.ContentNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.utils.FmtInternalLogicError;
import java.util.LinkedList;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.parser.DefinitionDefinition;
import org.sweble.wikitext.lazy.parser.DefinitionList;
import org.sweble.wikitext.lazy.parser.DefinitionTerm;
import org.sweble.wikitext.lazy.parser.Enumeration;
import org.sweble.wikitext.lazy.parser.EnumerationItem;
import org.sweble.wikitext.lazy.parser.ExternalLink;
import org.sweble.wikitext.lazy.parser.ImageLink;
import org.sweble.wikitext.lazy.parser.InternalLink;
import org.sweble.wikitext.lazy.parser.Itemization;
import org.sweble.wikitext.lazy.parser.ItemizationItem;
import org.sweble.wikitext.lazy.parser.LazyParsedPage;
import org.sweble.wikitext.lazy.parser.NamedXmlElement;
import org.sweble.wikitext.lazy.parser.RtData;
import org.sweble.wikitext.lazy.parser.Section;
import org.sweble.wikitext.lazy.parser.SemiPre;
import org.sweble.wikitext.lazy.parser.SemiPreLine;
import org.sweble.wikitext.lazy.parser.Table;
import org.sweble.wikitext.lazy.parser.TableCaption;
import org.sweble.wikitext.lazy.parser.TableCell;
import org.sweble.wikitext.lazy.parser.TableHeader;
import org.sweble.wikitext.lazy.parser.TableRow;
import org.sweble.wikitext.lazy.parser.XmlElement;
import org.sweble.wikitext.lazy.parser.XmlElementClose;
import org.sweble.wikitext.lazy.parser.XmlElementEmpty;
import org.sweble.wikitext.lazy.parser.XmlElementOpen;
import org.sweble.wikitext.lazy.postprocessor.ElementScopeStack;
import org.sweble.wikitext.lazy.postprocessor.ImTagClose;
import org.sweble.wikitext.lazy.postprocessor.ImTagOpen;
import org.sweble.wikitext.lazy.postprocessor.IntermediateTag;
import org.sweble.wikitext.lazy.postprocessor.ScopeType;
import org.sweble.wikitext.lazy.utils.TextUtils;

public class ScopedElementBuilder
extends AstVisitor {
    private final ParserConfigInterface config;
    private final ElementScopeStack stack = new ElementScopeStack();

    public static LazyParsedPage process(ParserConfigInterface config, AstNode ast) {
        return (LazyParsedPage)((Object)new ScopedElementBuilder(config).go(ast));
    }

    public ScopedElementBuilder(ParserConfigInterface config) {
        this.config = config;
    }

    protected Object after(AstNode node, Object result) {
        return node;
    }

    public void visit(AstNode n) {
        this.stack.append(n);
    }

    public void visit(LazyParsedPage n) {
        this.openScope(ScopeType.PAGE, (AstNode)n);
        this.processScope(n);
        this.closeScope(ScopeType.PAGE, (AstNode)n);
    }

    public void visit(ExternalLink n) {
        this.openScope(ScopeType.WT_INLINE, (AstNode)n);
        n.setTitle(this.processScope(n.getTitle()));
        this.closeScope(ScopeType.WT_INLINE, (AstNode)n);
    }

    public void visit(InternalLink n) {
        this.openScope(ScopeType.WT_INLINE, (AstNode)n);
        this.processScope(n.getTitle());
        this.closeScope(ScopeType.WT_INLINE, (AstNode)n);
    }

    public void visit(ImageLink n) {
        this.openScope(ScopeType.WT_INLINE, (AstNode)n);
        this.processScope(n.getTitle());
        this.closeScope(ScopeType.WT_INLINE, (AstNode)n);
    }

    public void visit(Section n) {
        this.openScope(ScopeType.WT_BLOCK, (AstNode)n);
        n.setTitle(this.processScope(n.getTitle()));
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_BLOCK, (AstNode)n);
    }

    public void visit(Table n) {
        this.openScope(ScopeType.WT_TABLE, (AstNode)n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE, (AstNode)n);
    }

    public void visit(TableCaption n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
    }

    public void visit(TableRow n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
    }

    public void visit(TableHeader n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
    }

    public void visit(TableCell n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, (AstNode)n);
    }

    public void visit(DefinitionList n) {
        this.openScope(ScopeType.WT_BLOCK, (AstNode)n);
        this.iterate((AstNode)n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, (AstNode)n);
    }

    public void visit(DefinitionTerm n) {
        this.processScope(n);
    }

    public void visit(DefinitionDefinition n) {
        this.processScope(n);
    }

    public void visit(Enumeration n) {
        this.openScope(ScopeType.WT_BLOCK, (AstNode)n);
        this.iterate((AstNode)n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, (AstNode)n);
    }

    public void visit(EnumerationItem n) {
        this.processScope(n);
    }

    public void visit(Itemization n) {
        this.openScope(ScopeType.WT_BLOCK, (AstNode)n);
        this.iterate((AstNode)n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, (AstNode)n);
    }

    public void visit(ItemizationItem n) {
        this.processScope(n);
    }

    public void visit(SemiPre n) {
        this.openScope(ScopeType.WT_BLOCK, (AstNode)n);
        this.iterate((AstNode)n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, (AstNode)n);
    }

    public void visit(SemiPreLine n) {
        this.processScope(n);
    }

    public void visit(XmlElementEmpty n) {
        if (n instanceof IntermediateTag || this.config.isXmlElementAllowed(n.getName())) {
            this.stack.append((AstNode)this.createEmptyElement(n));
        } else {
            this.stack.append((AstNode)n);
        }
    }

    public void visit(XmlElementOpen n) {
        String name = n.getName();
        if (n instanceof IntermediateTag || this.config.isXmlElementAllowed(name)) {
            if (this.config.isXmlElementEmptyOnly(name)) {
                this.stack.append((AstNode)this.createEmptyElement(n));
            } else {
                this.openScope(this.determineElementType(n), (AstNode)n);
            }
        } else {
            this.stack.append((AstNode)n);
        }
    }

    public void visit(XmlElementClose n) {
        String name = n.getName();
        if (n instanceof IntermediateTag || this.config.isXmlElementAllowed(name)) {
            this.closeScope(this.determineElementType(n), (AstNode)n);
        } else {
            this.stack.append((AstNode)n);
        }
    }

    private ScopeType determineElementType(NamedXmlElement n) {
        String name = n.getName().toLowerCase();
        if (name.startsWith("@")) {
            name = name.substring(1);
        }
        return this.config.getXmlElementType(name);
    }

    private void openScope(ScopeType scopeType, AstNode n) {
        this.stack.push(scopeType, n, true);
        if (scopeType.isCloseInline()) {
            this.closeBeforeBlock(scopeType.isCloseSamePred());
            if (scopeType.isReopenClosedInline() && !scopeType.isWikitextScope()) {
                this.reopenClosedInlineScopes();
            }
        }
    }

    private void processScope(ContentNode n) {
        n.setContent(this.processScope(n.getContent()));
    }

    private NodeList processScope(NodeList n) {
        ElementScopeStack.Scope container = this.stack.top();
        this.stack.push(ScopeType.WT_ELEMENT_BODY, (AstNode)n, true);
        ElementScopeStack.Scope current = this.stack.top();
        if (container.getType().isReopenClosedInline()) {
            this.reopenClosedInlineScopes(container.clearClosedInline());
        }
        this.iterate((AstNode)n);
        while (this.stack.top() != current) {
            ElementScopeStack.Scope s = this.stack.top();
            if (s.getType().isWikitextScope()) {
                throw new FmtInternalLogicError();
            }
            if (s.getType().isReopen() && container.getType().isPropagateOut()) {
                container.addClosedInline(s);
            } else if (!s.getType().isPropagateOut()) {
                container.clearClosedInline();
            }
            this.stack.top().previous().append(this.close(s));
            this.stack.pop();
        }
        this.stack.pop();
        return current.getContent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeScope(ScopeType scopeType, AstNode n) {
        ElementScopeStack.Scope current = this.stack.top();
        if (scopeType.isWikitextScope()) {
            if (current.getElement() != n || current.getType() != scopeType) {
                throw new FmtInternalLogicError();
            }
            this.stack.pop();
            if (scopeType != ScopeType.PAGE) {
                this.stack.append(n);
            }
            this.reopenClosedInlineScopes(current.getClosedInline());
            return;
        }
        NamedXmlElement closing = (NamedXmlElement)n;
        if (current.match(closing)) {
            this.stack.pop();
            this.stack.append(this.close(current, (AstNode)((XmlElementClose)n)));
            this.reopenClosedInlineScopes(current.getClosedInline());
            return;
        }
        ElementScopeStack.Scope s = this.findMatchingOpeningTag(scopeType, current, closing);
        if (s == null) {
            if (n instanceof ImTagClose) return;
            this.stack.append(n);
            return;
        }
        ElementScopeStack.Scope from = s;
        while (true) {
            ElementScopeStack.Scope toIncl;
            if ((s = s.next()) == null) {
                toIncl = this.stack.top();
                this.closeScopesBeforeClosingTag(from, toIncl, (XmlElementClose)n);
                return;
            }
            if (!s.getType().isWikitextScope()) continue;
            toIncl = s.previous();
            ElementScopeStack.Scope insert = s.next();
            this.closeScopesBeforeClosingTag(from, toIncl, insert);
            s = insert;
            from = insert.next();
            if (from == null) return;
        }
    }

    private void closeBeforeBlock(boolean closeSamePrec) {
        ElementScopeStack.Scope current = this.stack.top();
        boolean isRecordClosed = current.getType().isContinueClosed() || current.getType().isReopenClosedInline();
        ElementScopeStack.Scope i = current;
        while (i.hasPrevious()) {
            NamedXmlElement e;
            ElementScopeStack.Scope s = i.previous();
            if (s.getType().isClosableBeforeBlock()) {
                if (s.getType().isReopen() && isRecordClosed) {
                    current.addClosedInline(s);
                }
                s.previous().append(this.close(s));
                this.stack.drop(s);
                continue;
            }
            if (!closeSamePrec || !(current.getElement() instanceof NamedXmlElement) || !s.match(e = (NamedXmlElement)current.getElement())) break;
            s.previous().append(this.close(s));
            this.stack.drop(s);
            break;
        }
    }

    private void closeScopesBeforeClosingTag(ElementScopeStack.Scope from, ElementScopeStack.Scope toIncl, ElementScopeStack.Scope reopenIn) {
        ElementScopeStack.Scope i = toIncl;
        while (true) {
            if (i.getType().isReopen()) {
                NodeList c = null;
                if (!reopenIn.getContent().isEmpty()) {
                    c = reopenIn.clearContent();
                }
                ElementScopeStack.Scope s = this.stack.insertAfter(reopenIn, i.getType(), i.getElement(), false);
                if (c != null) {
                    s.setContent(c);
                }
            }
            i.previous().append(this.close(i));
            this.stack.drop(i);
            if (i == from) break;
            i = i.previous();
        }
    }

    private void closeScopesBeforeClosingTag(ElementScopeStack.Scope from, ElementScopeStack.Scope toIncl, XmlElementClose close_) {
        LinkedList<ElementScopeStack.Scope> reopen = null;
        boolean propagateOut = from.getType().isPropagateOut();
        ElementScopeStack.Scope i = toIncl;
        while (true) {
            if (i == from) {
                if (reopen == null) {
                    reopen = i.clearClosedInline();
                }
                if (i.getClosedInline() != null) {
                    reopen.addAll(0, i.getClosedInline());
                }
                if (i.match(close_)) {
                    i.previous().append(this.close(i, (AstNode)close_));
                    break;
                }
                i.previous().append(this.close(i));
                i.previous().append((AstNode)close_);
                break;
            }
            if (i.getType().isReopen() && propagateOut) {
                if (reopen == null) {
                    reopen = new LinkedList();
                }
                reopen.addFirst(i);
            }
            i.previous().append(this.close(i));
            this.stack.pop();
            i = i.previous();
        }
        this.stack.pop();
        if (from.getType().isContinueClosed()) {
            this.reopenClosedInlineScopes(reopen);
        }
    }

    private void reopenClosedInlineScopes() {
        ElementScopeStack.Scope current = this.stack.top();
        LinkedList<ElementScopeStack.Scope> closedInline = current.getClosedInline();
        if (closedInline != null) {
            this.reopenClosedInlineScopes(closedInline);
            current.clearClosedInline();
        }
    }

    private void reopenClosedInlineScopes(LinkedList<ElementScopeStack.Scope> closedInline) {
        if (closedInline != null) {
            for (ElementScopeStack.Scope s : closedInline) {
                this.stack.push(s.getType(), s.getElement(), false);
            }
        }
    }

    private ElementScopeStack.Scope findMatchingOpeningTag(ScopeType scopeType, ElementScopeStack.Scope current, NamedXmlElement closing) {
        if (scopeType.isInlineScope()) {
            return this.findMatchingInlineOpeningTag(scopeType, current, closing);
        }
        if (scopeType.isTableScope()) {
            return this.findMatchingTableOpeningTag(scopeType, current, closing);
        }
        if (scopeType.isBlockScope()) {
            return this.findMatchingBlockOpeningTag(scopeType, current, closing);
        }
        return this.findMatchingSpecialOpeningTag(scopeType, current, closing);
    }

    private ElementScopeStack.Scope findMatchingInlineOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s, NamedXmlElement closing) {
        while (!s.getType().isBlockScope()) {
            if ((s = s.previous()).match(closing)) {
                return s;
            }
            if (s.hasPrevious()) continue;
        }
        return null;
    }

    private ElementScopeStack.Scope findMatchingTableOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s, NamedXmlElement closing) {
        do {
            if (!(s = s.previous()).match(closing)) continue;
            return s;
        } while (s.hasPrevious());
        return null;
    }

    private ElementScopeStack.Scope findMatchingBlockOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s, NamedXmlElement closing) {
        while (!s.getType().isBlockScope()) {
            if ((s = s.previous()).match(closing)) {
                return s;
            }
            if (s.hasPrevious()) continue;
        }
        return null;
    }

    private ElementScopeStack.Scope findMatchingSpecialOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s, NamedXmlElement closing) {
        while (!s.getType().isTableScope()) {
            if ((s = s.previous()).match(closing)) {
                return s;
            }
            if (s.hasPrevious()) continue;
        }
        return null;
    }

    private AstNode close(ElementScopeStack.Scope s) {
        return this.close(s, null);
    }

    private AstNode close(ElementScopeStack.Scope s, AstNode c) {
        XmlElementOpen open;
        NodeList content = s.getContent();
        if (s.getType().dropIfEmpty() && content.isEmpty()) {
            return null;
        }
        if (content.size() == 1) {
            AstNode c0 = content.get(0);
            if (s.getType().dropIfOnlyWhitespace() && c0.isNodeType(196611) && !s.isOpen() && c == null) {
                return c0;
            }
        }
        if (s.getElement() instanceof ImTagOpen) {
            open = (ImTagOpen)s.getElement();
            ImTagClose close = (ImTagClose)c;
            return ((ImTagOpen)open).getType().transform(this.config, (ImTagOpen)open, close, content);
        }
        open = (XmlElementOpen)s.getElement();
        XmlElementClose close = (XmlElementClose)c;
        return this.createElement(open, content, close, s.isOpen());
    }

    private XmlElement createEmptyElement(XmlElementEmpty empty) {
        return this.createEmptyElement(empty, empty.getXmlAttributes(), true);
    }

    private XmlElement createEmptyElement(XmlElementOpen open) {
        return this.createEmptyElement(open, open.getXmlAttributes(), false);
    }

    private XmlElement createEmptyElement(NamedXmlElement e, NodeList attrs, boolean wasEmpty) {
        XmlElement element = new XmlElement(e.getName(), true, attrs, new NodeList());
        if (this.config.isGatherRtData()) {
            Object[] rtd1;
            Object[] rtd0;
            RtData rtd = (RtData)e.getAttribute("RTD");
            if (rtd == null) {
                rtd0 = TextUtils.joinRt(Character.valueOf('<'), e.getName());
                rtd1 = TextUtils.joinRt(wasEmpty ? " />" : Character.valueOf('>'));
            } else {
                rtd0 = rtd.getRts()[0];
                rtd1 = rtd.getRts()[1];
            }
            TextUtils.addRtData((AstNode)element, rtd0, rtd1, null);
        }
        return element;
    }

    private XmlElement createElement(XmlElementOpen open, NodeList body, XmlElementClose close, boolean hasOpen) {
        XmlElement e = new XmlElement(open.getName(), false, open.getXmlAttributes(), body);
        if (this.config.isGatherRtData()) {
            Object[] oRtd0 = null;
            Object[] oRtd1 = null;
            Object[] cRtd0 = null;
            if (hasOpen) {
                RtData a = (RtData)open.getAttribute("RTD");
                if (a == null) {
                    oRtd0 = TextUtils.joinRt(Character.valueOf('<'), open.getName());
                    oRtd1 = TextUtils.joinRt(Character.valueOf('>'));
                } else {
                    oRtd0 = a.getRts()[0];
                    oRtd1 = a.getRts()[1];
                }
            }
            if (close != null) {
                RtData b = (RtData)close.getAttribute("RTD");
                cRtd0 = b != null ? b.getRts()[0] : TextUtils.joinRt("</", open.getName(), Character.valueOf('>'));
            }
            TextUtils.addRtData((AstNode)e, oRtd0, oRtd1, cRtd0);
        }
        return e;
    }
}

