/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.postprocessor;

import de.fau.cs.osr.ptk.common.AstPrinter;
import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.utils.StringUtils;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.sweble.wikitext.lazy.parser.NamedXmlElement;
import org.sweble.wikitext.lazy.parser.XmlElementOpen;
import org.sweble.wikitext.lazy.postprocessor.ScopeType;

public final class ElementScopeStack
extends AstVisitor {
    Scope top = null;

    public Scope top() {
        return this.top;
    }

    public void push(ScopeType type, AstNode n, boolean open) {
        Scope s = new Scope(type, n, open);
        if (this.top == null) {
            this.top = s;
        } else {
            this.insertAfter(this.top, s);
        }
    }

    public Scope insertAfter(Scope i, ScopeType type, AstNode n, boolean open) {
        return this.insertAfter(i, new Scope(type, n, open));
    }

    private Scope insertAfter(Scope i, Scope insert) {
        insert.previous = i;
        insert.next = i.next;
        if (i.next != null) {
            i.next.previous = insert;
        }
        i.next = insert;
        if (i == this.top) {
            this.top = insert;
        }
        return insert;
    }

    public Scope drop(Scope s) {
        if (s == this.top) {
            throw new UnsupportedOperationException();
        }
        s.next.previous = s.previous;
        if (s.previous != null) {
            s.previous.next = s.next;
        }
        return s;
    }

    public Scope pop() {
        Scope old = this.top;
        if (this.top == null) {
            throw new NoSuchElementException();
        }
        this.top = this.top.previous();
        if (this.top != null) {
            this.top.next = null;
        }
        return old;
    }

    public void append(AstNode n) {
        this.top().append(n);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("ScopeStack:\n\n");
        int indent = 2;
        Scope i = this.top;
        if (i != null) {
            while (i.hasPrevious()) {
                i = i.previous();
            }
        }
        while (i != null) {
            s.append(StringUtils.indent((String)i.toString().trim(), (String)StringUtils.strrep((char)' ', (int)indent)));
            s.append("\n\n");
            indent += 2;
            i = i.next();
        }
        return s.toString();
    }

    public static final class Scope {
        private Scope previous;
        private Scope next;
        private final ScopeType type;
        private final AstNode element;
        private final boolean open;
        private NodeList content = new NodeList();
        private LinkedList<Scope> closedInline;

        public Scope(ScopeType type, AstNode n, boolean open) {
            this.type = type;
            this.element = n;
            this.open = open;
        }

        public boolean hasPrevious() {
            return this.previous != null;
        }

        public Scope previous() {
            return this.previous;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Scope next() {
            return this.next;
        }

        public AstNode getElement() {
            return this.element;
        }

        public NodeList getContent() {
            return this.content;
        }

        public ScopeType getType() {
            return this.type;
        }

        public LinkedList<Scope> getClosedInline() {
            return this.closedInline;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void append(AstNode n) {
            this.content.add(n);
        }

        public void addClosedInline(Scope s) {
            if (this.closedInline == null) {
                this.closedInline = new LinkedList();
            }
            this.closedInline.addFirst(s);
        }

        public LinkedList<Scope> clearClosedInline() {
            LinkedList<Scope> ci = this.closedInline;
            this.closedInline = null;
            return ci;
        }

        public boolean match(NamedXmlElement otherElement) {
            String on;
            NamedXmlElement e;
            String en;
            return this.element instanceof NamedXmlElement && (en = (e = (NamedXmlElement)this.element).getName()).equalsIgnoreCase(on = otherElement.getName());
        }

        public NodeList clearContent() {
            NodeList c = this.content;
            this.content = new NodeList();
            return c;
        }

        public void setContent(NodeList content) {
            this.content = content;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("Node: ");
            s.append(this.element.getClass().getSimpleName());
            switch (this.element.getNodeType()) {
                case 720936: {
                    s.append(": <");
                    XmlElementOpen e = (XmlElementOpen)this.element;
                    s.append(e.getName());
                    if (e.getXmlAttributes() != null && !e.getXmlAttributes().isEmpty()) {
                        s.append(' ');
                        s.append(e.getXmlAttributes().toString());
                    }
                    s.append('>');
                    break;
                }
                case 720934: {
                    s.append(": </");
                    XmlElementOpen e = (XmlElementOpen)this.element;
                    s.append(e.getName());
                    s.append('>');
                    break;
                }
            }
            s.append("\n");
            s.append("Type: ");
            s.append((Object)this.type);
            s.append("\n");
            if (this.closedInline != null) {
                s.append("Closed inline: ");
                int j = 0;
                for (Scope scope : this.closedInline) {
                    if (j++ > 0) {
                        s.append(", ");
                    }
                    s.append(scope.getElement().getClass().getSimpleName());
                }
                s.append("\n");
            }
            s.append("Content:\n");
            String c = AstPrinter.print((AstNode)this.content);
            c = StringUtils.indent((String)c.trim(), (String)"  | ");
            s.append(c);
            s.append("\n");
            return s.toString();
        }
    }
}

