/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.parser;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import org.sweble.wikitext.lazy.utils.RtWikitextPrinter;

public class RtData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object[][] rts;

    public RtData(Object[][] rts) {
        this.rts = rts;
    }

    public Object[][] getRts() {
        return this.rts;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RtData: ");
        int i = 0;
        for (Object[] part : this.rts) {
            if (i != 0) {
                b.append(", ");
            }
            b.append('[');
            b.append(i++);
            if (part != null) {
                b.append("] = \"");
                for (Object o : part) {
                    if (o == null) continue;
                    String s = o instanceof AstNode ? RtWikitextPrinter.print((AstNode)o) : o.toString();
                    b.append(StringUtils.escJava((String)s));
                }
                b.append('\"');
                continue;
            }
            b.append(']');
        }
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.rts);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RtData other = (RtData)obj;
        if (this.rts == null) {
            if (other.rts != null) {
                return false;
            }
        } else {
            if (this.rts.length != other.rts.length) {
                return false;
            }
            for (int i = 0; i < this.rts.length; ++i) {
                Object[] t = this.rts[i];
                Object[] o = other.rts[i];
                if (Arrays.equals(t, o)) continue;
                return false;
            }
        }
        return true;
    }
}

