/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.parser;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.Span;
import org.sweble.wikitext.lazy.parser.WarningSeverity;

public abstract class LazyWarning
extends Warning {
    private static final long serialVersionUID = 1L;
    protected final WarningSeverity severity;

    public LazyWarning(Span span, WarningSeverity severity, String origin, String message) {
        super(span, origin, message);
        this.severity = severity;
    }

    public LazyWarning(Span span, WarningSeverity severity, Class<?> origin, String message) {
        super(span, origin, message);
        this.severity = severity;
    }

    public WarningSeverity getSeverity() {
        return this.severity;
    }

    public String toString() {
        String span = this.spanToString();
        String message = this.messageToString();
        String severity = this.severityToString();
        return "Warning (" + severity + "): " + span + " : " + message;
    }

    protected String severityToString() {
        String severity = "-";
        if (this.getSeverity() != null) {
            severity = this.getSeverity().toString().toLowerCase();
        }
        return severity;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LazyWarning other = (LazyWarning)((Object)obj);
        return this.severity == other.severity;
    }
}

