/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy;

import de.fau.cs.osr.utils.XmlGrammar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.ParserConfigInterface;

public class LinkTargetParser {
    private String title;
    private String fragment;
    private String namespace;
    private String interwiki;
    private boolean initialColon;
    private static final Pattern bidiCharPattern = Pattern.compile("[\u200e\u200f\u202a-\u202e]");
    private static final Pattern spacePlusPattern = Pattern.compile("[ _\u00a0\u1680\u180e\u2000-\u200a\u2028\u2029\u202f\u205f\u3000]+");
    private static final Pattern namespaceSeparatorPattern = Pattern.compile("^(.+?)_*:_*(.*)$");
    private static final Pattern invalidTitle = Pattern.compile("(%[0-9A-Fa-f]{2})|(&((?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])(?:(?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])|-|\\.|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])*);)|((&#[0-9]+;)|(&#x[0-9A-Fa-f]+;))|(^\\.\\.?($|/))|(/\\.\\.?/)|(/\\.\\.?$)|(~~~)");

    public void parse(ParserConfigInterface config, String target) throws LinkTargetException {
        int i;
        Matcher matcher;
        String result = target;
        String resultNs = null;
        String resultIw = null;
        String resultFragment = null;
        boolean resultInitialColon = false;
        result = LinkTargetParser.urlDecode(result);
        result = LinkTargetParser.xmlDecode(config, result);
        Matcher matcher2 = bidiCharPattern.matcher(result);
        result = matcher2.replaceAll("");
        result = LinkTargetParser.trim(result);
        matcher2 = spacePlusPattern.matcher(result);
        result = matcher2.replaceAll("_");
        if ((result = LinkTargetParser.trimUnderscore(result)).isEmpty()) {
            throw new LinkTargetException(target, "Target has empty title");
        }
        if (result.charAt(0) == ':') {
            resultInitialColon = true;
            result = result.substring(1);
            result = LinkTargetParser.trimUnderscore(result);
        }
        boolean gotIl = false;
        boolean gotNsOrIl = false;
        while ((matcher = namespaceSeparatorPattern.matcher(result)).matches()) {
            String nsName = matcher.group(1);
            if (config.isNamespace(nsName)) {
                if (gotNsOrIl) {
                    throw new LinkTargetException(target, "The namespace in a link target may not be followed by another namespace or interwiki name");
                }
                result = matcher.group(2);
                resultNs = nsName;
                gotNsOrIl = true;
                continue;
            }
            if (!config.isInterwikiName(nsName)) break;
            if (gotNsOrIl || gotIl) {
                throw new LinkTargetException(target, "The namespace in a link target may not be followed by another namespace or interwiki name");
            }
            result = matcher.group(2);
            if (config.isLocalInterwikiName(nsName)) {
                if (result.isEmpty()) {
                    throw new LinkTargetException(target, "Empty article title!");
                }
                gotIl = true;
                continue;
            }
            resultIw = nsName;
            if (!result.isEmpty() && result.charAt(0) == ':') {
                resultInitialColon = true;
                result = result.substring(1);
                result = LinkTargetParser.trimUnderscore(result);
            }
            gotNsOrIl = true;
        }
        if ((i = result.indexOf(35)) != -1) {
            resultFragment = result.substring(i + 1);
            resultFragment = LinkTargetParser.trimUnderscore(resultFragment);
            result = result.substring(0, i);
            result = LinkTargetParser.trimUnderscore(result);
        }
        if ((matcher = invalidTitle.matcher(result)).find()) {
            throw new LinkTargetException(target, "The title contains invalid entities");
        }
        if (result.isEmpty() && resultIw == null && resultNs != null) {
            throw new LinkTargetException(target, "A namespace alone is not a valid link target");
        }
        this.title = result;
        this.fragment = resultFragment;
        this.namespace = resultNs;
        this.interwiki = resultIw;
        this.initialColon = resultInitialColon;
    }

    static String urlDecode(String result) {
        if (result.indexOf(37) >= 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < result.length(); ++i) {
                char ch = result.charAt(i);
                if (ch == '%' && i + 2 < result.length()) {
                    String num = result.substring(i + 1, i + 3);
                    try {
                        int val = Integer.valueOf(num, 16);
                        if (val >= 32 && val < 127) {
                            ch = (char)val;
                            i += 2;
                        }
                    }
                    catch (NumberFormatException e) {}
                } else if (ch == '+') {
                    ch = ' ';
                }
                b.append(ch);
            }
            result = b.toString();
        }
        return result;
    }

    static String xmlDecode(ParserConfigInterface config, String result) {
        if (result.indexOf(38) >= 0) {
            Matcher m;
            Pattern rx = XmlGrammar.xmlReference();
            int start = 0;
            StringBuilder b = new StringBuilder();
            while ((m = rx.matcher(result)).find(start)) {
                b.append(result.substring(start, m.start()));
                String resolved = null;
                if (m.group(1) != null) {
                    resolved = config.resolveXmlEntity(m.group(1));
                } else {
                    try {
                        boolean decimal = m.group(2) != null;
                        String num = decimal ? m.group(2) : m.group(3);
                        int val = Integer.valueOf(num, decimal ? 10 : 16);
                        if (val >= 32 && val != 127) {
                            resolved = String.valueOf((char)val);
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (resolved != null) {
                    b.append(resolved);
                } else {
                    b.append(result.substring(m.start(), m.end()));
                }
                start = m.end();
            }
            if (start < result.length()) {
                b.append(result.substring(start));
            }
            result = b.toString();
        }
        return result;
    }

    static String trimUnderscore(String result) {
        int j;
        int i;
        for (i = 0; i < result.length() && result.charAt(i) == '_'; ++i) {
        }
        for (j = result.length() - 1; j >= 0 && result.charAt(j) == '_'; --j) {
        }
        return result.substring(i, j + 1);
    }

    static String trim(String input) {
        int i;
        int j = input.length();
        for (i = 0; i < j && Character.isWhitespace(input.charAt(i)); ++i) {
        }
        while (i < j && Character.isWhitespace(input.charAt(j - 1))) {
            --j;
        }
        return i > 0 || j < input.length() ? input.substring(i, j) : input;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInterwiki() {
        return this.interwiki;
    }

    public boolean isInitialColon() {
        return this.initialColon;
    }
}

