/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.social.facebook.web.RealTimeUpdate;
import org.springframework.social.facebook.web.UpdateHandler;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/realtime/facebook"})
public class RealTimeUpdateController {
    private Map<String, String> tokens;
    private List<UpdateHandler> updateHandlers;
    private String applicationSecret;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String X_HUB_SIGNATURE = "X-Hub-Signature";
    private static final Log logger = LogFactory.getLog(RealTimeUpdateController.class);

    public RealTimeUpdateController(Map<String, String> tokens, List<UpdateHandler> updateHandlers, String applicationSecret) {
        this.tokens = tokens;
        this.updateHandlers = updateHandlers;
        this.applicationSecret = applicationSecret;
    }

    @RequestMapping(value={"/{subscription}"}, method={RequestMethod.GET}, params={"hub.mode=subscribe"})
    @ResponseBody
    public String verifySubscription(@PathVariable(value="subscription") String subscription, @RequestParam(value="hub.challenge") String challenge, @RequestParam(value="hub.verify_token") String verifyToken) {
        logger.debug((Object)("Received subscription verification request for '" + subscription + "'."));
        return this.tokens.containsKey(subscription) && this.tokens.get(subscription).equals(verifyToken) ? challenge : "";
    }

    @RequestMapping(value={"/{subscription}"}, method={RequestMethod.POST})
    @ResponseBody
    public String receiveUpdate(@PathVariable(value="subscription") String subscription, @RequestBody String payload, @RequestHeader(value="X-Hub-Signature") String signature) throws Exception {
        RealTimeUpdate update = (RealTimeUpdate)new ObjectMapper().readValue(payload, RealTimeUpdate.class);
        if (this.verifySignature(payload, signature)) {
            logger.debug((Object)("Received " + update.getObject() + " update for '" + subscription + "'."));
            for (UpdateHandler handler : this.updateHandlers) {
                handler.handleUpdate(subscription, update);
            }
        } else {
            logger.warn((Object)"Received an update, but signature was invalid. Not delegating to handlers.");
        }
        return "";
    }

    private boolean verifySignature(String payload, String signature) throws Exception {
        if (!signature.startsWith("sha1=")) {
            return false;
        }
        String expected = signature.substring(5);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        SecretKeySpec signingKey = new SecretKeySpec(this.applicationSecret.getBytes(), HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(payload.getBytes());
        String actual = new String(Hex.encode((byte[])rawHmac));
        return expected.equals(actual);
    }
}

