/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.web.SignInAdapter;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.web.SignedRequestDecoder;
import org.springframework.social.facebook.web.SignedRequestException;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/canvas"})
public class CanvasSignInController {
    private static final Log logger = LogFactory.getLog(CanvasSignInController.class);
    private final String clientId;
    private final String canvasPage;
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final UsersConnectionRepository usersConnectionRepository;
    private final SignInAdapter signInAdapter;
    private final SignedRequestDecoder signedRequestDecoder;
    private String postSignInUrl = "/";
    private String postDeclineUrl = "http://www.facebook.com";
    private String scope;

    @Inject
    public CanvasSignInController(ConnectionFactoryLocator connectionFactoryLocator, UsersConnectionRepository usersConnectionRepository, SignInAdapter signInAdapter, String clientId, String clientSecret, String canvasPage) {
        this.usersConnectionRepository = usersConnectionRepository;
        this.signInAdapter = signInAdapter;
        this.clientId = clientId;
        this.canvasPage = canvasPage;
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.signedRequestDecoder = new SignedRequestDecoder(clientSecret);
    }

    public void setPostSignInUrl(String postSignInUrl) {
        this.postSignInUrl = postSignInUrl;
    }

    public void setPostDeclineUrl(String postDeclineUrl) {
        this.postDeclineUrl = postDeclineUrl;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @RequestMapping(method={RequestMethod.POST, RequestMethod.GET}, params={"signed_request", "!error"})
    public View signin(Model model, NativeWebRequest request) throws SignedRequestException {
        String signedRequest = request.getParameter("signed_request");
        if (signedRequest == null) {
            this.debug("Expected a signed_request parameter, but none given. Redirecting to the application's Canvas Page: " + this.canvasPage);
            return new RedirectView(this.canvasPage, false);
        }
        Map<String, ?> decodedSignedRequest = this.signedRequestDecoder.decodeSignedRequest(signedRequest);
        String accessToken = (String)decodedSignedRequest.get("oauth_token");
        if (accessToken == null) {
            this.debug("No access token in the signed_request parameter. Redirecting to the authorization dialog.");
            model.addAttribute("clientId", (Object)this.clientId);
            model.addAttribute("canvasPage", (Object)this.canvasPage);
            if (this.scope != null) {
                model.addAttribute("scope", (Object)this.scope);
            }
            return new TopLevelWindowRedirect(){

                @Override
                protected String getRedirectUrl(Map<String, ?> model) {
                    String clientId = (String)model.get("clientId");
                    String canvasPage = (String)model.get("canvasPage");
                    String scope = (String)model.get("scope");
                    String redirectUrl = "https://www.facebook.com/dialog/oauth?client_id=" + clientId + "&redirect_uri=" + canvasPage;
                    if (scope != null) {
                        redirectUrl = redirectUrl + "&scope=" + CanvasSignInController.this.formEncode(scope);
                    }
                    return redirectUrl;
                }
            };
        }
        this.debug("Access token available in signed_request parameter. Creating connection and signing in.");
        OAuth2ConnectionFactory connectionFactory = (OAuth2ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(Facebook.class);
        AccessGrant accessGrant = new AccessGrant(accessToken);
        Connection connection = connectionFactory.createConnection(accessGrant);
        this.handleSignIn((Connection<Facebook>)connection, request);
        this.debug("Signed in. Redirecting to post-signin page.");
        return new RedirectView(this.postSignInUrl, true);
    }

    @RequestMapping(method={RequestMethod.POST, RequestMethod.GET}, params={"error"})
    public View error(@RequestParam(value="error") String error, @RequestParam(value="error_description") String errorDescription) {
        String string = "User declined authorization: '" + errorDescription + "'. Redirecting to " + this.postDeclineUrl;
        this.debug(string);
        return this.postDeclineView();
    }

    protected View postDeclineView() {
        return new TopLevelWindowRedirect(){

            @Override
            protected String getRedirectUrl(Map<String, ?> model) {
                return CanvasSignInController.this.postDeclineUrl;
            }
        };
    }

    private void debug(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)string);
        }
    }

    private void handleSignIn(Connection<Facebook> connection, NativeWebRequest request) {
        List userIds = this.usersConnectionRepository.findUserIdsWithConnection(connection);
        if (userIds.size() == 1) {
            this.usersConnectionRepository.createConnectionRepository((String)userIds.get(0)).updateConnection(connection);
            this.signInAdapter.signIn((String)userIds.get(0), connection, request);
        } else {
            logger.error((Object)("Expected exactly 1 matching user. Got " + userIds.size() + " metching users."));
        }
    }

    private String formEncode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TopLevelWindowRedirect
    implements View {
        private TopLevelWindowRedirect() {
        }

        public String getContentType() {
            return "text/html";
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            response.getWriter().write("<script>");
            response.getWriter().write("top.location.href='" + this.getRedirectUrl(model) + "';");
            response.getWriter().write("</script>");
            response.flushBuffer();
        }

        protected abstract String getRedirectUrl(Map<String, ?> var1);
    }
}

