/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.util.Arrays;
import java.util.List;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class AclAuthorizationStrategyImpl
implements AclAuthorizationStrategy {
    private GrantedAuthority gaGeneralChanges;
    private GrantedAuthority gaModifyAuditing;
    private GrantedAuthority gaTakeOwnership;
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();

    public AclAuthorizationStrategyImpl(GrantedAuthority[] auths) {
        Assert.isTrue((auths != null && auths.length == 3 ? 1 : 0) != 0, (String)"GrantedAuthority[] with three elements required");
        this.gaTakeOwnership = auths[0];
        this.gaModifyAuditing = auths[1];
        this.gaGeneralChanges = auths[2];
    }

    public void securityCheck(Acl acl, int changeType) {
        if (SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null || !SecurityContextHolder.getContext().getAuthentication().isAuthenticated()) {
            throw new AccessDeniedException("Authenticated principal required to operate with ACLs");
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid currentUser = new PrincipalSid(authentication);
        if (((Object)currentUser).equals(acl.getOwner()) && (changeType == 2 || changeType == 0)) {
            return;
        }
        GrantedAuthority requiredAuthority = null;
        if (changeType == 1) {
            requiredAuthority = this.gaModifyAuditing;
        } else if (changeType == 2) {
            requiredAuthority = this.gaGeneralChanges;
        } else if (changeType == 0) {
            requiredAuthority = this.gaTakeOwnership;
        } else {
            throw new IllegalArgumentException("Unknown change type");
        }
        if (authentication.getAuthorities().contains(requiredAuthority)) {
            return;
        }
        List<Sid> sids = this.sidRetrievalStrategy.getSids(authentication);
        if (acl.isGranted(Arrays.asList(BasePermission.ADMINISTRATION), sids, false)) {
            return;
        }
        throw new AccessDeniedException("Principal does not have required ACL permissions to perform requested operation");
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, (String)"SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }
}

