/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.util.List;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.Assert;

public abstract class AbstractPersistentAcceptOnceFileListFilter<F>
extends AbstractFileListFilter<F>
implements ReversibleFileListFilter<F> {
    protected final ConcurrentMetadataStore store;
    protected final String prefix;
    private final Object monitor = new Object();

    public AbstractPersistentAcceptOnceFileListFilter(ConcurrentMetadataStore store, String prefix) {
        Assert.notNull((Object)store, (String)"'store' cannot be null");
        Assert.notNull((Object)prefix, (String)"'prefix' cannot be null");
        this.store = store;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean accept(F file) {
        String key = this.buildKey(file);
        Object object = this.monitor;
        synchronized (object) {
            String newValue = this.value(file);
            String oldValue = this.store.putIfAbsent(key, newValue);
            if (oldValue == null) {
                return true;
            }
            return !this.isEqual(file, oldValue) && this.store.replace(key, oldValue, newValue);
        }
    }

    @Override
    public void rollback(F file, List<F> files) {
        boolean rollingBack = false;
        for (F fileToRollback : files) {
            if (fileToRollback.equals(file)) {
                rollingBack = true;
            }
            if (!rollingBack) continue;
            this.store.remove(this.buildKey(fileToRollback));
        }
    }

    private String value(F file) {
        return Long.toString(this.modified(file));
    }

    protected boolean isEqual(F file, String value) {
        return Long.valueOf(value).longValue() == this.modified(file);
    }

    protected String buildKey(F file) {
        return this.prefix + this.fileName(file);
    }

    protected abstract long modified(F var1);

    protected abstract String fileName(F var1);
}

