/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInboundFileSynchronizingMessageSource<F>
extends MessageProducerSupport
implements MessageSource<File> {
    private volatile boolean autoCreateLocalDirectory = true;
    private final AbstractInboundFileSynchronizer<F> synchronizer;
    private volatile File localDirectory;
    private final FileReadingMessageSource fileSource;

    public AbstractInboundFileSynchronizingMessageSource(AbstractInboundFileSynchronizer<F> synchronizer) {
        this(synchronizer, null);
    }

    public AbstractInboundFileSynchronizingMessageSource(AbstractInboundFileSynchronizer<F> synchronizer, Comparator<File> comparator) {
        Assert.notNull(synchronizer, (String)"synchronizer must not be null");
        this.synchronizer = synchronizer;
        this.fileSource = comparator == null ? new FileReadingMessageSource() : new FileReadingMessageSource(comparator);
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setLocalDirectory(File localDirectory) {
        this.localDirectory = localDirectory;
    }

    protected void onInit() {
        Assert.notNull((Object)this.localDirectory, (String)"localDirectory must not be null");
        try {
            if (!this.localDirectory.exists()) {
                if (this.autoCreateLocalDirectory) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("The '" + this.localDirectory + "' directory doesn't exist; Will create."));
                    }
                    this.localDirectory.mkdirs();
                } else {
                    throw new FileNotFoundException(this.localDirectory.getName());
                }
            }
            this.fileSource.setDirectory(this.localDirectory);
            this.fileSource.setFilter(this.buildFilter());
            this.fileSource.afterPropertiesSet();
            this.synchronizer.afterPropertiesSet();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("Failure during initialization of MessageSource for: " + this.getComponentType(), (Throwable)e);
        }
    }

    public final Message<File> receive() {
        Assert.state((this.fileSource != null ? 1 : 0) != 0, (String)"fileSource must not be null");
        Assert.state((this.synchronizer != null ? 1 : 0) != 0, (String)"synchronizer must not be null");
        Message<File> message = this.fileSource.receive();
        if (message == null) {
            this.synchronizer.synchronizeToLocalDirectory(this.localDirectory);
            message = this.fileSource.receive();
        }
        return message;
    }

    private FileListFilter<File> buildFilter() {
        Pattern completePattern = Pattern.compile("^.*(?<!" + this.synchronizer.getTemporaryFileSuffix() + ")$");
        return new CompositeFileListFilter<File>(Arrays.asList(new AcceptOnceFileListFilter(), new RegexPatternFileListFilter(completePattern)));
    }
}

