/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.util.SimplePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingSessionFactory<F>
implements SessionFactory<F>,
DisposableBean {
    private static final Log logger = LogFactory.getLog(CachingSessionFactory.class);
    private final SessionFactory<F> sessionFactory;
    private final SimplePool<Session<F>> pool;

    public CachingSessionFactory(SessionFactory<F> sessionFactory) {
        this(sessionFactory, 0);
    }

    public CachingSessionFactory(SessionFactory<F> sessionFactory, int sessionCacheSize) {
        this.sessionFactory = sessionFactory;
        this.pool = new SimplePool(sessionCacheSize, new SimplePool.PoolItemCallback<Session<F>>(){

            public Session<F> createForPool() {
                return CachingSessionFactory.this.sessionFactory.getSession();
            }

            public boolean isStale(Session<F> session) {
                return !session.isOpen();
            }

            public void removedFromPool(Session<F> session) {
                session.close();
            }
        });
    }

    public void setSessionWaitTimeout(long sessionWaitTimeout) {
        this.pool.setWaitTimeout(sessionWaitTimeout);
    }

    public void setPoolSize(int poolSize) {
        this.pool.setPoolSize(poolSize);
    }

    @Override
    public Session<F> getSession() {
        return new CachedSession((Session)this.pool.getItem());
    }

    public void destroy() {
        this.pool.removeAllIdleItems();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedSession
    implements Session<F> {
        private final Session<F> targetSession;
        private boolean released;

        private CachedSession(Session<F> targetSession) {
            this.targetSession = targetSession;
        }

        @Override
        public synchronized void close() {
            if (this.released) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Session already released.");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Releasing Session back to the pool.");
                }
                CachingSessionFactory.this.pool.releaseItem(this.targetSession);
                this.released = true;
            }
        }

        @Override
        public boolean remove(String path) throws IOException {
            return this.targetSession.remove(path);
        }

        @Override
        public F[] list(String path) throws IOException {
            return this.targetSession.list(path);
        }

        @Override
        public void read(String source, OutputStream os) throws IOException {
            this.targetSession.read(source, os);
        }

        @Override
        public void write(InputStream inputStream, String destination) throws IOException {
            this.targetSession.write(inputStream, destination);
        }

        @Override
        public boolean isOpen() {
            return this.targetSession.isOpen();
        }

        @Override
        public void rename(String pathFrom, String pathTo) throws IOException {
            this.targetSession.rename(pathFrom, pathTo);
        }

        @Override
        public boolean mkdir(String directory) throws IOException {
            return this.targetSession.mkdir(directory);
        }

        @Override
        public boolean exists(String path) throws IOException {
            return this.targetSession.exists(path);
        }

        @Override
        public String[] listNames(String path) throws IOException {
            return this.targetSession.listNames(path);
        }
    }
}

