/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.event.outbound;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.Message;
import org.springframework.integration.event.core.MessagingEvent;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.util.Assert;

public class ApplicationEventPublishingMessageHandler
extends AbstractMessageHandler
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void handleMessageInternal(Message<?> message) {
        Assert.notNull((Object)this.applicationEventPublisher, (String)"applicationEventPublisher is required");
        if (message.getPayload() instanceof ApplicationEvent) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)message.getPayload());
        } else {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new MessagingEvent(message));
        }
    }
}

