/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.util.Assert;

class LimitOperation
implements AggregationOperation {
    private final long maxElements;

    public LimitOperation(long maxElements) {
        Assert.isTrue((maxElements >= 0L ? 1 : 0) != 0, (String)"Maximum number of elements must be greater or equal to zero!");
        this.maxElements = maxElements;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        return new BasicDBObject("$limit", (Object)this.maxElements);
    }
}

