/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.Locale;
import org.springframework.data.mongodb.core.mapping.FieldNamingStrategy;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;

public class CamelCaseAbbreviatingFieldNamingStrategy
implements FieldNamingStrategy {
    private static final String CAMEL_CASE_PATTERN = "(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])";

    @Override
    public String getFieldName(MongoPersistentProperty property) {
        String[] parts = property.getName().split(CAMEL_CASE_PATTERN);
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(part.substring(0, 1).toLowerCase(Locale.US));
        }
        return builder.toString();
    }
}

