/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexType;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeospatialIndex
implements IndexDefinition {
    private final String field;
    private String name;
    private Integer min;
    private Integer max;
    private Integer bits;
    private GeoSpatialIndexType type = GeoSpatialIndexType.GEO_2D;
    private Double bucketSize = 1.0;
    private String additionalField;

    public GeospatialIndex(String field) {
        Assert.hasText((String)field, (String)"Field must have text!");
        this.field = field;
    }

    public GeospatialIndex named(String name) {
        Assert.hasText((String)name, (String)"Name must have text!");
        this.name = name;
        return this;
    }

    public GeospatialIndex withMin(int min) {
        this.min = min;
        return this;
    }

    public GeospatialIndex withMax(int max) {
        this.max = max;
        return this;
    }

    public GeospatialIndex withBits(int bits) {
        this.bits = bits;
        return this;
    }

    public GeospatialIndex typed(GeoSpatialIndexType type) {
        Assert.notNull((Object)((Object)type), (String)"Type must not be null!");
        this.type = type;
        return this;
    }

    public GeospatialIndex withBucketSize(double bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public GeospatialIndex withAdditionalField(String fieldName) {
        this.additionalField = fieldName;
        return this;
    }

    @Override
    public DBObject getIndexKeys() {
        BasicDBObject dbo = new BasicDBObject();
        switch (this.type) {
            case GEO_2D: {
                dbo.put(this.field, (Object)"2d");
                break;
            }
            case GEO_2DSPHERE: {
                dbo.put(this.field, (Object)"2dsphere");
                break;
            }
            case GEO_HAYSTACK: {
                dbo.put(this.field, (Object)"geoHaystack");
                if (!StringUtils.hasText((String)this.additionalField)) {
                    throw new IllegalArgumentException("When defining geoHaystack index, an additionnal field must be defined");
                }
                dbo.put(this.additionalField, (Object)1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported geospatial index " + (Object)((Object)this.type));
            }
        }
        return dbo;
    }

    @Override
    public DBObject getIndexOptions() {
        if (this.name == null && this.min == null && this.max == null && this.bucketSize == null) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        if (this.name != null) {
            dbo.put("name", (Object)this.name);
        }
        switch (this.type) {
            case GEO_2D: {
                if (this.min != null) {
                    dbo.put("min", (Object)this.min);
                }
                if (this.max != null) {
                    dbo.put("max", (Object)this.max);
                }
                if (this.bits == null) break;
                dbo.put("bits", (Object)this.bits);
                break;
            }
            case GEO_2DSPHERE: {
                break;
            }
            case GEO_HAYSTACK: {
                if (this.bucketSize == null) break;
                dbo.put("bucketSize", (Object)this.bucketSize);
            }
        }
        return dbo;
    }

    public String toString() {
        return String.format("Geo index: %s - Options: %s", this.getIndexKeys(), this.getIndexOptions());
    }
}

