/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import com.mongodb.DBObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMongoEventListener<E>
implements ApplicationListener<MongoMappingEvent<?>> {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    private final Class<?> domainClass;

    public AbstractMongoEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractMongoEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    public void onApplicationEvent(MongoMappingEvent<?> event) {
        if (event instanceof AfterLoadEvent) {
            AfterLoadEvent afterLoadEvent = (AfterLoadEvent)event;
            if (this.domainClass.isAssignableFrom(afterLoadEvent.getType())) {
                this.onAfterLoad(event.getDBObject());
            }
            return;
        }
        Object source = event.getSource();
        if (source != null && !this.domainClass.isAssignableFrom(source.getClass())) {
            return;
        }
        if (event instanceof BeforeConvertEvent) {
            this.onBeforeConvert(source);
        } else if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave(source, event.getDBObject());
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave(source, event.getDBObject());
        } else if (event instanceof AfterConvertEvent) {
            this.onAfterConvert(event.getDBObject(), source);
        }
    }

    public void onBeforeConvert(E source) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("onBeforeConvert(" + source + ")"));
        }
    }

    public void onBeforeSave(E source, DBObject dbo) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("onBeforeSave(" + source + ", " + dbo + ")"));
        }
    }

    public void onAfterSave(E source, DBObject dbo) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("onAfterSave(" + source + ", " + dbo + ")"));
        }
    }

    public void onAfterLoad(DBObject dbo) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("onAfterLoad(" + dbo + ")"));
        }
    }

    public void onAfterConvert(DBObject dbo, E source) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("onAfterConvert(" + dbo + "," + source + ")"));
        }
    }
}

