/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoURI;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoDbUtils;
import org.springframework.util.Assert;

public class SimpleMongoDbFactory
implements DisposableBean,
MongoDbFactory {
    private final Mongo mongo;
    private final String databaseName;
    private final boolean mongoInstanceCreated;
    private final UserCredentials credentials;
    private WriteConcern writeConcern;

    public SimpleMongoDbFactory(Mongo mongo, String databaseName) {
        this(mongo, databaseName, new UserCredentials(), false);
    }

    public SimpleMongoDbFactory(Mongo mongo, String databaseName, UserCredentials credentials) {
        this(mongo, databaseName, credentials, false);
    }

    public SimpleMongoDbFactory(MongoURI uri) throws MongoException, UnknownHostException {
        this(new Mongo(uri), uri.getDatabase(), new UserCredentials(uri.getUsername(), SimpleMongoDbFactory.parseChars(uri.getPassword())), true);
    }

    private SimpleMongoDbFactory(Mongo mongo, String databaseName, UserCredentials credentials, boolean mongoInstanceCreated) {
        Assert.notNull((Object)mongo, (String)"Mongo must not be null");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty");
        Assert.isTrue((boolean)databaseName.matches("[\\w-]+"), (String)"Database name must only contain letters, numbers, underscores and dashes!");
        this.mongo = mongo;
        this.databaseName = databaseName;
        this.mongoInstanceCreated = mongoInstanceCreated;
        this.credentials = credentials == null ? new UserCredentials() : credentials;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public DB getDb() throws DataAccessException {
        return this.getDb(this.databaseName);
    }

    public DB getDb(String dbName) throws DataAccessException {
        Assert.hasText((String)dbName, (String)"Database name must not be empty.");
        String username = this.credentials.getUsername();
        String password = this.credentials.getPassword();
        DB db = MongoDbUtils.getDB(this.mongo, dbName, username, password == null ? null : password.toCharArray());
        if (this.writeConcern != null) {
            db.setWriteConcern(this.writeConcern);
        }
        return db;
    }

    public void destroy() throws Exception {
        if (this.mongoInstanceCreated) {
            this.mongo.close();
        }
    }

    private static String parseChars(char[] chars) {
        return chars == null ? null : String.valueOf(chars);
    }
}

