/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.range.RangeFacetBuilder;
import org.springframework.data.elasticsearch.core.facet.AbstractFacetRequest;
import org.springframework.util.Assert;

public class RangeFacetRequest
extends AbstractFacetRequest {
    private String field;
    private String keyField;
    private String valueField;
    private List<Entry> entries = new ArrayList<Entry>();

    public RangeFacetRequest(String name) {
        super(name);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFields(String keyField, String valueField) {
        this.keyField = keyField;
        this.valueField = valueField;
    }

    public void range(Double from, Double to) {
        this.entries.add(new DoubleEntry(from, to));
    }

    public void range(String from, String to) {
        this.entries.add(new StringEntry(from, to));
    }

    public void addRange(Double from, Double to) {
        this.entries.add(new DoubleEntry(from, to));
    }

    public void addRange(String from, String to) {
        this.entries.add(new StringEntry(from, to));
    }

    @Override
    public FacetBuilder getFacet() {
        Assert.notNull((Object)this.getName(), (String)"Facet name can't be a null !!!");
        Assert.isTrue((StringUtils.isNotBlank((String)this.field) || StringUtils.isNotBlank((String)this.keyField) && StringUtils.isNotBlank((String)this.valueField) ? 1 : 0) != 0, (String)"Please select field or key field and value field !!!");
        RangeFacetBuilder builder = FacetBuilders.rangeFacet((String)this.getName());
        if (StringUtils.isNotBlank((String)this.keyField)) {
            builder.keyField(this.keyField).valueField(this.valueField);
        } else {
            builder.field(this.field);
        }
        for (Entry entry : this.entries) {
            if (entry instanceof DoubleEntry) {
                DoubleEntry doubleEntry = (DoubleEntry)entry;
                builder.addRange(this.validateValue((Double)doubleEntry.getFrom(), Double.NEGATIVE_INFINITY), this.validateValue((Double)doubleEntry.getTo(), Double.POSITIVE_INFINITY));
                continue;
            }
            StringEntry stringEntry = (StringEntry)entry;
            builder.addRange((String)stringEntry.getFrom(), (String)stringEntry.getTo());
        }
        return builder;
    }

    private double validateValue(Double value, double defaultValue) {
        return value == null ? defaultValue : value;
    }

    static class Entry<T> {
        T from;
        T to;

        Entry(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public T getFrom() {
            return this.from;
        }

        public T getTo() {
            return this.to;
        }
    }

    static class StringEntry
    extends Entry<String> {
        StringEntry(String from, String to) {
            super(from, to);
        }
    }

    static class DoubleEntry
    extends Entry<Double> {
        DoubleEntry(Double from, Double to) {
            super(from, to);
        }
    }
}

