/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.FacetedPage;
import org.springframework.data.elasticsearch.core.facet.FacetResult;

public class FacetedPageImpl<T>
extends PageImpl<T>
implements FacetedPage<T> {
    private List<FacetResult> facets;
    private Map<String, FacetResult> mapOfFacets = new HashMap<String, FacetResult>();

    public FacetedPageImpl(List<T> content) {
        super(content);
    }

    public FacetedPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
    }

    public FacetedPageImpl(List<T> content, Pageable pageable, long total, List<FacetResult> facets) {
        super(content, pageable, total);
        this.facets = facets;
        for (FacetResult facet : facets) {
            this.mapOfFacets.put(facet.getName(), facet);
        }
    }

    @Override
    public boolean hasFacets() {
        return CollectionUtils.isNotEmpty(this.facets);
    }

    @Override
    public List<FacetResult> getFacets() {
        return this.facets;
    }

    @Override
    public FacetResult getFacet(String name) {
        return this.mapOfFacets.get(name);
    }
}

