/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.List;
import org.springframework.data.domain.Chunk;
import org.springframework.data.domain.Pageable;

public class SliceImpl<T>
extends Chunk<T> {
    private static final long serialVersionUID = 867755909294344406L;
    private final boolean hasNext;

    public SliceImpl(List<T> content, Pageable pageable, boolean hasNext) {
        super(content, pageable);
        this.hasNext = hasNext;
    }

    public SliceImpl(List<T> content) {
        this(content, null, false);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List content = this.getContent();
        if (content.size() > 0) {
            contentType = content.get(0).getClass().getName();
        }
        return String.format("Slice %s of %d containing %s instances", this.getNumber(), contentType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SliceImpl)) {
            return false;
        }
        SliceImpl that = (SliceImpl)obj;
        return this.hasNext == that.hasNext && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result += 31 * (this.hasNext ? 1 : 0);
        return result += 31 * super.hashCode();
    }
}

