/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.builder;

import java.lang.ref.WeakReference;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.Ordered;

public class ParentContextCloserApplicationListener
implements ApplicationListener<ParentContextApplicationContextInitializer.ParentContextAvailableEvent>,
Ordered {
    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void onApplicationEvent(ParentContextApplicationContextInitializer.ParentContextAvailableEvent event) {
        this.maybeInstallListenerInParent(event.getApplicationContext());
    }

    private void maybeInstallListenerInParent(ConfigurableApplicationContext child) {
        if (child.getParent() instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext parent = (ConfigurableApplicationContext)child.getParent();
            parent.addApplicationListener((ApplicationListener)this.createContextCloserListener(child));
        }
    }

    protected ContextCloserListener createContextCloserListener(ConfigurableApplicationContext child) {
        return new ContextCloserListener(child);
    }

    protected static class ContextCloserListener
    implements ApplicationListener<ContextClosedEvent> {
        private WeakReference<ConfigurableApplicationContext> childContext;

        public ContextCloserListener(ConfigurableApplicationContext childContext) {
            this.childContext = new WeakReference<ConfigurableApplicationContext>(childContext);
        }

        public void onApplicationEvent(ContextClosedEvent event) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.childContext.get();
            if (context != null && event.getApplicationContext() == context.getParent() && context.isActive()) {
                context.close();
            }
        }
    }
}

