/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.template;

import org.springframework.util.Assert;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

public abstract class AbstractTemplateViewResolverProperties {
    private String prefix;
    private String suffix;
    private boolean cache;
    private String contentType = "text/html";
    private String charSet = "UTF-8";
    private String[] viewNames;
    private boolean checkTemplateLocation = true;
    private String requestContextAttribute;
    private boolean exposeRequestAttributes = false;
    private boolean exposeSessionAttributes = false;
    private boolean allowRequestOverride = false;
    private boolean exposeSpringMacroHelpers = true;

    protected AbstractTemplateViewResolverProperties(String defaultPrefix, String defaultSuffix) {
        this.prefix = defaultPrefix;
        this.suffix = defaultSuffix;
    }

    public void setCheckTemplateLocation(boolean checkTemplateLocation) {
        this.checkTemplateLocation = checkTemplateLocation;
    }

    public boolean isCheckTemplateLocation() {
        return this.checkTemplateLocation;
    }

    public String[] getViewNames() {
        return this.viewNames;
    }

    public void setViewNames(String[] viewNames) {
        this.viewNames = viewNames;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getContentType() {
        return this.contentType + (this.contentType.contains(";charset=") ? "" : ";charset=" + this.charSet);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public boolean isExposeRequestAttributes() {
        return this.exposeRequestAttributes;
    }

    public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
        this.exposeRequestAttributes = exposeRequestAttributes;
    }

    public boolean isExposeSessionAttributes() {
        return this.exposeSessionAttributes;
    }

    public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
        this.exposeSessionAttributes = exposeSessionAttributes;
    }

    public boolean isAllowRequestOverride() {
        return this.allowRequestOverride;
    }

    public void setAllowRequestOverride(boolean allowRequestOverride) {
        this.allowRequestOverride = allowRequestOverride;
    }

    public boolean isExposeSpringMacroHelpers() {
        return this.exposeSpringMacroHelpers;
    }

    public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
        this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
    }

    public void applyToViewResolver(Object viewResolver) {
        Assert.isInstanceOf(AbstractTemplateViewResolver.class, (Object)viewResolver, (String)("ViewResolver is not an instance of AbstractTemplateViewResolver :" + viewResolver));
        AbstractTemplateViewResolver resolver = (AbstractTemplateViewResolver)viewResolver;
        resolver.setPrefix(this.getPrefix());
        resolver.setSuffix(this.getSuffix());
        resolver.setCache(this.isCache());
        resolver.setContentType(this.getContentType());
        resolver.setViewNames(this.getViewNames());
        resolver.setExposeRequestAttributes(this.isExposeRequestAttributes());
        resolver.setAllowRequestOverride(this.isAllowRequestOverride());
        resolver.setExposeSessionAttributes(this.isExposeSessionAttributes());
        resolver.setExposeSpringMacroHelpers(this.isExposeSpringMacroHelpers());
        resolver.setRequestContextAttribute(this.getRequestContextAttribute());
        resolver.setOrder(0x7FFFFFFA);
    }
}

