/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mobile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.mobile.device.view.LiteDeviceDelegatingViewResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={LiteDeviceDelegatingViewResolver.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, ThymeleafAutoConfiguration.class})
public class DeviceDelegatingViewResolverAutoConfiguration {
    private static Log logger = LogFactory.getLog(DeviceDelegatingViewResolverAutoConfiguration.class);

    @Configuration
    @ConditionalOnMissingBean(name={"deviceDelegatingViewResolver"})
    @ConditionalOnExpression(value="${spring.mobile.devicedelegatingviewresolver.enabled:false}")
    protected static class DeviceDelegatingViewResolverConfiguration {
        protected DeviceDelegatingViewResolverConfiguration() {
        }

        @Configuration
        @ConditionalOnMissingBean(name={"thymeleafViewResolver"})
        @ConditionalOnBean(value={InternalResourceViewResolver.class})
        protected static class InternalResourceViewResolverDelegateConfiguration
        extends AbstractDelegateConfiguration {
            @Autowired
            private InternalResourceViewResolver viewResolver;

            protected InternalResourceViewResolverDelegateConfiguration() {
            }

            @Bean
            public LiteDeviceDelegatingViewResolver deviceDelegatingViewResolver() {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"LiteDeviceDelegatingViewResolver delegates to InternalResourceViewResolver");
                }
                return this.getConfiguredViewResolver((ViewResolver)this.viewResolver, this.viewResolver.getOrder());
            }
        }

        @Configuration
        @ConditionalOnBean(name={"thymeleafViewResolver"})
        protected static class ThymeleafViewResolverViewResolverDelegateConfiguration
        extends AbstractDelegateConfiguration {
            @Autowired
            private ThymeleafViewResolver viewResolver;

            protected ThymeleafViewResolverViewResolverDelegateConfiguration() {
            }

            @Bean
            public LiteDeviceDelegatingViewResolver deviceDelegatingViewResolver() {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"LiteDeviceDelegatingViewResolver delegates to ThymeleafViewResolver");
                }
                return this.getConfiguredViewResolver((ViewResolver)this.viewResolver, this.viewResolver.getOrder());
            }
        }
    }

    private static abstract class AbstractDelegateConfiguration
    implements EnvironmentAware {
        private RelaxedPropertyResolver environment;

        private AbstractDelegateConfiguration() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.mobile.devicedelegatingviewresolver.");
        }

        protected LiteDeviceDelegatingViewResolver getConfiguredViewResolver(ViewResolver delegate, int delegateOrder) {
            LiteDeviceDelegatingViewResolver resolver = new LiteDeviceDelegatingViewResolver(delegate);
            resolver.setNormalPrefix(this.getProperty("normal-prefix", ""));
            resolver.setNormalSuffix(this.getProperty("normal-suffix", ""));
            resolver.setMobilePrefix(this.getProperty("mobile-prefix", "mobile/"));
            resolver.setMobileSuffix(this.getProperty("mobile-suffix", ""));
            resolver.setTabletPrefix(this.getProperty("tablet-prefix", "tablet/"));
            resolver.setTabletSuffix(this.getProperty("tablet-suffix", ""));
            resolver.setOrder(this.getAdjustedOrder(delegateOrder));
            return resolver;
        }

        private String getProperty(String key, String defaultValue) {
            return this.environment.getProperty(key, defaultValue);
        }

        private int getAdjustedOrder(int order) {
            if (order == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return order - 1;
        }
    }
}

