/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.security;

import java.util.HashMap;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.security.access.event.AbstractAuthorizationEvent;
import org.springframework.security.access.event.AuthenticationCredentialsNotFoundEvent;
import org.springframework.security.access.event.AuthorizationFailureEvent;

public class AuthorizationAuditListener
implements ApplicationListener<AbstractAuthorizationEvent>,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void onApplicationEvent(AbstractAuthorizationEvent event) {
        if (event instanceof AuthenticationCredentialsNotFoundEvent) {
            this.onAuthenticationCredentialsNotFoundEvent((AuthenticationCredentialsNotFoundEvent)event);
        } else if (event instanceof AuthorizationFailureEvent) {
            this.onAuthorizationFailureEvent((AuthorizationFailureEvent)event);
        }
    }

    private void onAuthenticationCredentialsNotFoundEvent(AuthenticationCredentialsNotFoundEvent event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", event.getCredentialsNotFoundException().getClass().getName());
        data.put("message", event.getCredentialsNotFoundException().getMessage());
        this.publish(new AuditEvent("<unknown>", "AUTHENTICATION_FAILURE", data));
    }

    private void onAuthorizationFailureEvent(AuthorizationFailureEvent event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", event.getAccessDeniedException().getClass().getName());
        data.put("message", event.getAccessDeniedException().getMessage());
        this.publish(new AuditEvent(event.getAuthentication().getName(), "AUTHORIZATION_FAILURE", data));
    }

    private void publish(AuditEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(event));
        }
    }
}

