/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.rich;

import java.util.ArrayList;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MultiMetricRepository;
import org.springframework.boot.actuate.metrics.rich.RichGauge;
import org.springframework.boot.actuate.metrics.rich.RichGaugeReader;

public class MultiMetricRichGaugeReader
implements RichGaugeReader {
    private static final String COUNT = ".count";
    private static final String MAX = ".max";
    private static final String MIN = ".min";
    private static final String AVG = ".avg";
    private static final String ALPHA = ".alpha";
    private static final String VAL = ".val";
    private final MultiMetricRepository repository;

    public MultiMetricRichGaugeReader(MultiMetricRepository repository) {
        this.repository = repository;
    }

    @Override
    public RichGauge findOne(String name) {
        Iterable<Metric<?>> metrics = this.repository.findAll(name);
        double value = 0.0;
        double average = 0.0;
        double alpha = -1.0;
        double min = 0.0;
        double max = 0.0;
        long count = 0L;
        for (Metric<?> metric : metrics) {
            if (metric.getName().endsWith(VAL)) {
                value = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(ALPHA)) {
                alpha = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(AVG)) {
                average = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(MIN)) {
                min = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(MAX)) {
                max = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (!metric.getName().endsWith(COUNT)) continue;
            count = ((Number)metric.getValue()).longValue();
        }
        return new RichGauge(name, value, alpha, average, max, min, count);
    }

    @Override
    public Iterable<RichGauge> findAll() {
        ArrayList<RichGauge> result = new ArrayList<RichGauge>();
        for (String name : this.repository.groups()) {
            result.add(this.findOne(name));
        }
        return result;
    }

    @Override
    public long count() {
        return this.repository.countGroups();
    }
}

