/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.vfs.FS;
import org.crsh.vfs.spi.AbstractFSDriver;
import org.crsh.vfs.spi.FSDriver;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementSecurityAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.ShellProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.SpringVersion;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={PluginLifeCycle.class})
@EnableConfigurationProperties(value={ShellProperties.class})
@AutoConfigureAfter(value={SecurityAutoConfiguration.class, ManagementSecurityAutoConfiguration.class})
public class CrshAutoConfiguration {
    @Autowired
    private ShellProperties properties;

    @Bean
    @ConditionalOnExpression(value="'${shell.auth:simple}' == 'jaas'")
    @ConditionalOnMissingBean(value={ShellProperties.CrshShellAuthenticationProperties.class})
    public ShellProperties.CrshShellAuthenticationProperties jaasAuthenticationProperties() {
        return new ShellProperties.JaasAuthenticationProperties();
    }

    @Bean
    @ConditionalOnExpression(value="'${shell.auth:simple}' == 'key'")
    @ConditionalOnMissingBean(value={ShellProperties.CrshShellAuthenticationProperties.class})
    public ShellProperties.CrshShellAuthenticationProperties keyAuthenticationProperties() {
        return new ShellProperties.KeyAuthenticationProperties();
    }

    @Bean
    @ConditionalOnExpression(value="'${shell.auth:simple}' == 'simple'")
    @ConditionalOnMissingBean(value={ShellProperties.CrshShellAuthenticationProperties.class})
    public ShellProperties.CrshShellAuthenticationProperties simpleAuthenticationProperties() {
        return new ShellProperties.SimpleAuthenticationProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={PluginLifeCycle.class})
    public PluginLifeCycle shellBootstrap() {
        CrshBootstrapBean bootstrapBean = new CrshBootstrapBean();
        bootstrapBean.setConfig(this.properties.asCrshShellConfig());
        return bootstrapBean;
    }

    private static class FileHandle
    extends ResourceHandle {
        private final Resource resource;

        public FileHandle(String name, Resource resource) {
            super(name);
            this.resource = resource;
        }

        public InputStream openStream() throws IOException {
            return this.resource.getInputStream();
        }

        public long getLastModified() {
            try {
                return this.resource.lastModified();
            }
            catch (IOException ex) {
                return -1L;
            }
        }
    }

    private static class DirectoryHandle
    extends ResourceHandle {
        private final ResourcePatternResolver resourceLoader;
        private final String[] filterPatterns;
        private final AntPathMatcher matcher = new AntPathMatcher();

        public DirectoryHandle(String name, ResourcePatternResolver resourceLoader, String[] filterPatterns) {
            super(name);
            this.resourceLoader = resourceLoader;
            this.filterPatterns = filterPatterns;
        }

        public List<ResourceHandle> members() throws IOException {
            Resource[] resources = this.resourceLoader.getResources(this.getName());
            ArrayList<ResourceHandle> files = new ArrayList<ResourceHandle>();
            for (Resource resource : resources) {
                if (resource.getURL().getPath().endsWith("/") || this.shouldFilter(resource)) continue;
                files.add(new FileHandle(resource.getFilename(), resource));
            }
            return files;
        }

        private boolean shouldFilter(Resource resource) {
            for (String filterPattern : this.filterPatterns) {
                if (!this.matcher.match(filterPattern, resource.getFilename())) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class ResourceHandle {
        private final String name;

        public ResourceHandle(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class SimpleFileSystemDriver
    extends AbstractFSDriver<ResourceHandle> {
        private final ResourceHandle root;

        public SimpleFileSystemDriver(ResourceHandle handle) {
            this.root = handle;
        }

        public Iterable<ResourceHandle> children(ResourceHandle handle) throws IOException {
            if (handle instanceof DirectoryHandle) {
                return ((DirectoryHandle)handle).members();
            }
            return Collections.emptySet();
        }

        public long getLastModified(ResourceHandle handle) throws IOException {
            if (handle instanceof FileHandle) {
                return ((FileHandle)handle).getLastModified();
            }
            return -1L;
        }

        public boolean isDir(ResourceHandle handle) throws IOException {
            return handle instanceof DirectoryHandle;
        }

        public String name(ResourceHandle handle) throws IOException {
            return handle.getName();
        }

        public Iterator<InputStream> open(ResourceHandle handle) throws IOException {
            if (handle instanceof FileHandle) {
                return Collections.singletonList(((FileHandle)handle).openStream()).iterator();
            }
            return Collections.emptyList().iterator();
        }

        public ResourceHandle root() throws IOException {
            return this.root;
        }
    }

    private static class BeanFactoryFilteringPluginDiscovery
    extends ServiceLoaderDiscovery {
        private final ListableBeanFactory beanFactory;
        private final String[] disabledPlugins;

        public BeanFactoryFilteringPluginDiscovery(ClassLoader classLoader, ListableBeanFactory beanFactory, String[] disabledPlugins) throws NullPointerException {
            super(classLoader);
            this.beanFactory = beanFactory;
            this.disabledPlugins = disabledPlugins;
        }

        public Iterable<CRaSHPlugin<?>> getPlugins() {
            ArrayList plugins = new ArrayList();
            for (CRaSHPlugin p : super.getPlugins()) {
                if (!this.isEnabled(p)) continue;
                plugins.add(p);
            }
            Collection pluginBeans = this.beanFactory.getBeansOfType(CRaSHPlugin.class).values();
            for (CRaSHPlugin pluginBean : pluginBeans) {
                if (!this.isEnabled(pluginBean)) continue;
                plugins.add(pluginBean);
            }
            return plugins;
        }

        protected boolean isEnabled(CRaSHPlugin<?> plugin) {
            Assert.notNull(plugin, (String)"Plugin must not be null");
            if (ObjectUtils.isEmpty((Object[])this.disabledPlugins)) {
                return true;
            }
            Set pluginClasses = ClassUtils.getAllInterfacesAsSet(plugin);
            pluginClasses.add(plugin.getClass());
            for (Class pluginClass : pluginClasses) {
                if (!this.isEnabled(pluginClass)) continue;
                return true;
            }
            return false;
        }

        private boolean isEnabled(Class<?> pluginClass) {
            for (String disabledPlugin : this.disabledPlugins) {
                if (!ClassUtils.getShortName(pluginClass).equalsIgnoreCase(disabledPlugin) && !ClassUtils.getQualifiedName(pluginClass).equalsIgnoreCase(disabledPlugin)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AuthenticationManagerAdapter
    extends CRaSHPlugin<AuthenticationPlugin>
    implements AuthenticationPlugin<String> {
        private static final PropertyDescriptor<String> ROLES = PropertyDescriptor.create((String)"auth.spring.roles", (String)"ADMIN", (String)"Comma separated list of roles required to access the shell");
        @Autowired
        private AuthenticationManager authenticationManager;
        @Autowired(required=false)
        private AccessDecisionManager accessDecisionManager;
        private String[] roles = new String[]{"ADMIN"};

        private AuthenticationManagerAdapter() {
        }

        public boolean authenticate(String username, String password) throws Exception {
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            try {
                token = this.authenticationManager.authenticate((Authentication)token);
            }
            catch (AuthenticationException ex) {
                return false;
            }
            if (this.accessDecisionManager != null && token.isAuthenticated() && this.roles != null) {
                try {
                    this.accessDecisionManager.decide((Authentication)token, (Object)this, (Collection)SecurityConfig.createList((String[])this.roles));
                }
                catch (AccessDeniedException ex) {
                    return false;
                }
            }
            return token.isAuthenticated();
        }

        public Class<String> getCredentialType() {
            return String.class;
        }

        public AuthenticationPlugin<String> getImplementation() {
            return this;
        }

        public String getName() {
            return "spring";
        }

        public void init() {
            String rolesPropertyValue = (String)this.getContext().getProperty(ROLES);
            if (rolesPropertyValue != null) {
                this.roles = StringUtils.commaDelimitedListToStringArray((String)rolesPropertyValue);
            }
        }

        protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
            return Arrays.asList(ROLES);
        }
    }

    public static class CrshBootstrapBean
    extends PluginLifeCycle {
        @Autowired
        private ListableBeanFactory beanFactory;
        @Autowired
        private Environment environment;
        @Autowired
        private ShellProperties properties;
        @Autowired
        private ResourcePatternResolver resourceLoader;

        @PreDestroy
        public void destroy() {
            this.stop();
        }

        @PostConstruct
        public void init() {
            FS commandFileSystem = this.createFileSystem(this.properties.getCommandPathPatterns(), this.properties.getDisabledCommands());
            FS configurationFileSystem = this.createFileSystem(this.properties.getConfigPathPatterns(), new String[0]);
            BeanFactoryFilteringPluginDiscovery discovery = new BeanFactoryFilteringPluginDiscovery(this.resourceLoader.getClassLoader(), this.beanFactory, this.properties.getDisabledPlugins());
            PluginContext context = new PluginContext((PluginDiscovery)discovery, this.createPluginContextAttributes(), commandFileSystem, configurationFileSystem, this.resourceLoader.getClassLoader());
            context.refresh();
            this.start(context);
        }

        protected FS createFileSystem(String[] pathPatterns, String[] filterPatterns) {
            Assert.notNull((Object)pathPatterns, (String)"PathPatterns must not be null");
            Assert.notNull((Object)filterPatterns, (String)"FilterPatterns must not be null");
            FS fileSystem = new FS();
            for (String pathPattern : pathPatterns) {
                try {
                    fileSystem.mount((FSDriver)new SimpleFileSystemDriver(new DirectoryHandle(pathPattern, this.resourceLoader, filterPatterns)));
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Failed to mount file system for '" + pathPattern + "'", ex);
                }
            }
            return fileSystem;
        }

        protected Map<String, Object> createPluginContextAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            String bootVersion = CrshAutoConfiguration.class.getPackage().getImplementationVersion();
            if (bootVersion != null) {
                attributes.put("spring.boot.version", bootVersion);
            }
            attributes.put("spring.version", SpringVersion.getVersion());
            if (this.beanFactory != null) {
                attributes.put("spring.beanfactory", this.beanFactory);
            }
            if (this.environment != null) {
                attributes.put("spring.environment", this.environment);
            }
            return attributes;
        }
    }

    @Configuration
    @ConditionalOnBean(value={AuthenticationManager.class})
    @AutoConfigureAfter(value={CrshAutoConfiguration.class})
    public static class AuthenticationManagerAdapterAutoConfiguration {
        @Autowired(required=false)
        private ManagementServerProperties management;

        @Bean
        public CRaSHPlugin<?> shellAuthenticationManager() {
            return new AuthenticationManagerAdapter();
        }

        @Bean
        @ConditionalOnExpression(value="'${shell.auth:spring}' == 'spring'")
        @ConditionalOnMissingBean(value={ShellProperties.CrshShellAuthenticationProperties.class})
        public ShellProperties.CrshShellAuthenticationProperties springAuthenticationProperties() {
            ShellProperties.SpringAuthenticationProperties authenticationProperties = new ShellProperties.SpringAuthenticationProperties();
            if (this.management != null) {
                authenticationProperties.setRoles(new String[]{this.management.getSecurity().getRole()});
            }
            return authenticationProperties;
        }
    }
}

