/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.AbstractMetricExporter;
import org.springframework.boot.actuate.metrics.reader.PrefixMetricReader;
import org.springframework.boot.actuate.metrics.repository.MultiMetricRepository;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class PrefixMetricGroupExporter
extends AbstractMetricExporter {
    private final PrefixMetricReader reader;
    private final MetricWriter writer;
    private Set<String> groups = new HashSet<String>();

    public PrefixMetricGroupExporter(PrefixMetricReader reader, MetricWriter writer) {
        this(reader, writer, "");
    }

    public PrefixMetricGroupExporter(PrefixMetricReader reader, MetricWriter writer, String prefix) {
        super(prefix);
        this.reader = reader;
        this.writer = writer;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Override
    protected Iterable<String> groups() {
        return this.groups;
    }

    @Override
    protected Iterable<Metric<?>> next(String group) {
        return this.reader.findAll(group);
    }

    @Override
    protected void write(String group, Collection<Metric<?>> values) {
        if (this.writer instanceof MultiMetricRepository && !values.isEmpty()) {
            ((MultiMetricRepository)((Object)this.writer)).save(group, values);
        } else {
            for (Metric<?> value : values) {
                this.writer.set(value);
            }
        }
    }
}

