/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.web.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BasicErrorController
implements ErrorController {
    private static final String ERROR_KEY = "error";
    private final Log logger = LogFactory.getLog(BasicErrorController.class);
    @Value(value="${error.path:/error}")
    private String errorPath;

    @Override
    public String getErrorPath() {
        return this.errorPath;
    }

    @RequestMapping(value={"${error.path:/error}"}, produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request) {
        Map<String, Object> map = this.extract((RequestAttributes)new ServletRequestAttributes(request), false, false);
        return new ModelAndView(ERROR_KEY, map);
    }

    @RequestMapping(value={"${error.path:/error}"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        ServletRequestAttributes attributes = new ServletRequestAttributes(request);
        String trace = request.getParameter("trace");
        Map<String, Object> extracted = this.extract((RequestAttributes)attributes, trace != null && !"false".equals(trace.toLowerCase()), true);
        HttpStatus statusCode = this.getStatus((Integer)extracted.get("status"));
        return new ResponseEntity(extracted, statusCode);
    }

    private HttpStatus getStatus(Integer value) {
        try {
            return HttpStatus.valueOf((int)value);
        }
        catch (Exception ex) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
    }

    @Override
    public Map<String, Object> extract(RequestAttributes attributes, boolean trace, boolean log) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("timestamp", new Date());
        try {
            Throwable error = (Throwable)attributes.getAttribute("javax.servlet.error.exception", 0);
            Object obj = attributes.getAttribute("javax.servlet.error.status_code", 0);
            int status = 999;
            if (obj != null) {
                status = (Integer)obj;
                map.put(ERROR_KEY, HttpStatus.valueOf((int)status).getReasonPhrase());
            } else {
                map.put(ERROR_KEY, "None");
            }
            map.put("status", status);
            if (error != null) {
                while (error instanceof ServletException && error.getCause() != null) {
                    error = ((ServletException)error).getCause();
                }
                map.put("exception", error.getClass().getName());
                map.put("message", error.getMessage());
                if (trace) {
                    StringWriter stackTrace = new StringWriter();
                    error.printStackTrace(new PrintWriter(stackTrace));
                    stackTrace.flush();
                    map.put("trace", stackTrace.toString());
                }
                if (log) {
                    this.logger.error((Object)error);
                }
            } else {
                Object message = attributes.getAttribute("javax.servlet.error.message", 0);
                map.put("message", message == null ? "No message available" : message);
            }
            return map;
        }
        catch (Exception ex) {
            map.put(ERROR_KEY, ex.getClass().getName());
            map.put("message", ex.getMessage());
            if (log) {
                this.logger.error((Object)ex);
            }
            return map;
        }
    }
}

