/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.util;

import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SimpleInMemoryRepository<T> {
    private ConcurrentNavigableMap<String, T> values = new ConcurrentSkipListMap<String, T>();
    private final ConcurrentMap<String, Object> locks = new ConcurrentReferenceHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T update(String name, Callback<T> callback) {
        Object lock = this.locks.putIfAbsent(name, new Object());
        if (lock == null) {
            lock = this.locks.get(name);
        }
        Object object = lock;
        synchronized (object) {
            Object current = this.values.get(name);
            T value = callback.modify(current);
            if (current != null) {
                this.values.replace(name, current, value);
            } else {
                this.values.putIfAbsent(name, value);
            }
            return (T)this.values.get(name);
        }
    }

    public void set(String name, T value) {
        Object current = this.values.get(name);
        if (current != null) {
            this.values.replace(name, current, value);
        } else {
            this.values.putIfAbsent(name, value);
        }
    }

    public long count() {
        return this.values.size();
    }

    public void remove(String name) {
        this.values.remove(name);
    }

    public T findOne(String name) {
        if (this.values.containsKey(name)) {
            return (T)this.values.get(name);
        }
        return null;
    }

    public Iterable<T> findAll() {
        return new ArrayList(this.values.values());
    }

    public Iterable<T> findAllWithPrefix(String prefix) {
        if (prefix.endsWith(".*")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return new ArrayList(this.values.subMap((Object)prefix, false, (Object)(prefix + "~"), true).values());
    }

    public void setValues(ConcurrentNavigableMap<String, T> values) {
        this.values = values;
    }

    protected NavigableMap<String, T> getValues() {
        return this.values;
    }

    public static interface Callback<T> {
        public T modify(T var1);
    }
}

