/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;

public class InMemoryAuditEventRepository
implements AuditEventRepository {
    private int capacity = 100;
    private final Map<String, List<AuditEvent>> events = new HashMap<String, List<AuditEvent>>();

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AuditEvent> find(String principal, Date after) {
        Map<String, List<AuditEvent>> map = this.events;
        synchronized (map) {
            return Collections.unmodifiableList(this.getEvents(principal));
        }
    }

    private List<AuditEvent> getEvents(String principal) {
        if (!this.events.containsKey(principal)) {
            this.events.put(principal, new ArrayList());
        }
        return this.events.get(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AuditEvent event) {
        Map<String, List<AuditEvent>> map = this.events;
        synchronized (map) {
            List<AuditEvent> list = this.getEvents(event.getPrincipal());
            while (list.size() >= this.capacity) {
                list.remove(0);
            }
            list.add(event);
        }
    }
}

