/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars2.rdfxml;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RDFXMLParserBase
extends DefaultHandler {
    private static Logger _log = Logger.getLogger(RDFXMLParserBase.class.getName());
    private boolean _skolemise = false;
    private boolean _strict = false;
    private String _escapedDocURI = null;
    public static final String BNODE_PREFIX = "bnode";
    private static final String XML_BASE = "xml:base";
    private static final String XML_LANG = "xml:lang";
    private static final String XML_SPACE = "xml:space";
    private static final String XML_ID = "xml:id";
    private static final String XML_PREFIX = "xml:";
    private static final String NULL = "";
    private ArrayList<Node> _fifoS;
    private ScopedThing<URI> _sbq;
    private ScopedThing<String> _slang;
    private TreeSet<Integer> _sptr;
    private Resource _sptlp = null;
    private int _sptldepth = 0;
    private HashMap<Integer, Integer> _li;
    private HashMap<Integer, Node> _coll;
    private HashSet<String> _ids;
    private URI _currentBase;
    private int _currentLi = 0;
    private Node _currentColl = null;
    private Node _currentReify = null;
    private int _depth = 0;
    private int _bnode = 0;
    private String _currentLang = null;
    private Resource _datatype = null;
    private HashMap<String, String> _xmllPrefixes = null;
    private StringBuffer _prefixDefinition = null;
    private Resource _con = null;
    private State _state = State.START;
    private ResourceDescription _currentPRD = null;
    private Node _currentS = null;
    private Resource _currentP = null;
    private Locator _loc = null;
    private StringBuffer _currentL = null;
    private Callback _c;
    private static final Node[] NOT_ALLOWED_NODE = new Node[]{RDF.ABOUT, RDF.DATATYPE, RDF.ID, RDF.NODEID, RDF.PARSETYPE, RDF.RESOURCE};
    private static final HashSet<Node> NOT_ALLOWED_NODE_TS = new HashSet();
    private static final String[] RDF_SUBJ_NODE_NAMES = new String[]{"Description", "Bag", "Seq", "Alt", "List", "Statement", "Property"};
    private static final String[] RDF_PROP_NODE_NAMES = new String[]{"type", "subject", "predicate", "object", "first", "rest", "value", "li"};
    private static final String[] RDF_SUBJ_ATTR_NAMES = new String[]{"about", "ID", "nodeID", "type"};
    private static final String[] RDF_PROP_ATTR_NAMES = new String[]{"ID", "nodeID", "datatype", "parseType", "resource"};
    private static final HashSet<String> RDF_SUBJ_NODE_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_PROP_NODE_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_SUBJ_ATTR_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_PROP_ATTR_NAMES_TS = new HashSet();

    public RDFXMLParserBase(String string, Callback callback) throws SAXException {
        this(string, callback, true, null);
    }

    public RDFXMLParserBase(String string, Callback callback, boolean bl) throws SAXException {
        this(string, callback, bl, null);
    }

    public RDFXMLParserBase(String string, Callback callback, boolean bl, boolean bl2) throws SAXException {
        this(string, callback, bl, bl2, null);
    }

    public RDFXMLParserBase(String string, Callback callback, boolean bl, Resource resource) throws SAXException {
        this(string, callback, bl, false, resource);
    }

    public RDFXMLParserBase(String string, Callback callback, boolean bl, boolean bl2, Resource resource) throws SAXException {
        for (Node object : NOT_ALLOWED_NODE) {
            NOT_ALLOWED_NODE_TS.add(object);
        }
        for (String string2 : RDF_SUBJ_NODE_NAMES) {
            RDF_SUBJ_NODE_NAMES_TS.add(string2);
        }
        for (String string3 : RDF_PROP_NODE_NAMES) {
            RDF_PROP_NODE_NAMES_TS.add(string3);
        }
        for (String string4 : RDF_SUBJ_ATTR_NAMES) {
            RDF_SUBJ_ATTR_NAMES_TS.add(string4);
        }
        for (String string5 : RDF_PROP_ATTR_NAMES) {
            RDF_PROP_ATTR_NAMES_TS.add(string5);
        }
        this._fifoS = new ArrayList();
        this.initialiseBaseURI(string);
        this.setDocumentURI(string);
        this._sbq = new ScopedThing<URI>(this._currentBase);
        this._sptr = new TreeSet();
        this._slang = new ScopedThing<String>(NULL);
        this._li = new HashMap();
        this._coll = new HashMap();
        this._ids = new HashSet();
        this._skolemise = bl;
        this._c = callback;
        this._con = resource;
        this._strict = bl2;
    }

    private void setDocumentURI(String string) {
        this._escapedDocURI = BNode.escapeForBNode(string);
    }

    @Override
    public void startDocument() throws SAXException {
        this._c.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this._c.endDocument();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Resource resource;
        if (string == null || string.equals(NULL) && !this._state.equals(State.PTL_XML)) {
            if (string2.equals("RDF") && this._state.equals(State.START)) {
                this.warning("Unqualified use of 'rdf:RDF' is deprecated.");
                resource = RDF.RDF;
            } else if (RDF_SUBJ_NODE_NAMES_TS.contains(string2) && this._state.expectOpenResource()) {
                this.warning("Unqualified use of RDF name '" + string2 + "' is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else if (RDF_PROP_NODE_NAMES_TS.contains(string2) && this._state.expectOpenProperty()) {
                this.warning("Unqualified use of RDF name '" + string2 + "' is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else {
                this.error("Unqualified attribute name '" + string2 + "' found.");
                resource = new Resource(this.resolveFullURI(string2, false));
            }
        } else {
            resource = new Resource(string + string2);
        }
        this.nodeIsAllowed(string3, resource);
        if (this._state.equals(State.START)) {
            this.checkAndHandleLang(attributes);
            this.checkAndHandleBaseURI(attributes);
            this._state = State.OR;
            if (!resource.equals(RDF.RDF)) {
                this.initialiseCurrentResource(resource, attributes);
                this._state = State.CR_OP;
            }
        } else if (this._state.equals(State.OR)) {
            this.initialiseCurrentResource(resource, attributes);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.CR_OP)) {
            this._state = State.T_CP_OR;
            this.initialiseCurrentProperty(resource, attributes);
        } else if (this._state.equals(State.T_CP_OR)) {
            this._currentL = null;
            Node node = this._currentS;
            this.initialiseCurrentResource(resource, attributes);
            this.handleStatement(node, this._currentP, this._currentS);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.CP)) {
            this.fatalError("Expecting close property tag, not open element tag '" + string3 + "'.");
        } else if (this._state.equals(State.T_CP)) {
            this.fatalError("Expecting close property, not open element tag '" + string3 + "'.");
        } else if (this._state.equals(State.PTC_OR_CP)) {
            BNode bNode = this.generateBNode();
            if (this._currentColl == null) {
                this.handleStatement(this._currentS, this._currentP, bNode);
                this._fifoS.add(this._currentS);
            } else {
                this.handleStatement(this._currentColl, RDF.REST, bNode);
            }
            this.initialiseCurrentResource(resource, attributes);
            this.handleStatement(bNode, RDF.FIRST, this._currentS);
            this._currentColl = null;
            this._coll.put(this._depth, bNode);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.PTL_XML)) {
            if (resource.equals(this._sptlp)) {
                ++this._sptldepth;
            }
            this.handleParseTypeLiteralStartElement(string, string2, string3, attributes);
        } else if (this._state.equals(State.PTR_OP_CP)) {
            Node node = this._currentS;
            this._currentS = this.generateBNode();
            this._fifoS.add(this._currentS);
            this.handleStatement(node, this._currentP, this._currentS);
            this._state = State.T_CP_OR;
            this.initialiseCurrentProperty(resource, attributes);
        }
        this._sbq.incrementScope();
        this._slang.incrementScope();
    }

    private void handleParseTypeLiteralStartElement(String string, String string2, String string3, Attributes attributes) {
        this.checkXMLLiteralPrefix(string, string2, string3);
        this._currentL.append("<" + string3);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this._currentL.append(" " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
            this.checkXMLLiteralPrefix(attributes.getURI(i), attributes.getQName(i), attributes.getLocalName(i));
        }
        if (this._prefixDefinition != null) {
            this._currentL.append(this._prefixDefinition.toString());
            this._prefixDefinition = null;
        }
        this._currentL.append(">");
    }

    private void checkAndHandleBaseURI(Attributes attributes) throws SAXException {
        int n = attributes.getIndex(XML_BASE);
        if (n == -1) {
            return;
        }
        this.initialiseBaseURI(attributes.getValue(n));
        this._sbq.addNewScopedElement(this._currentBase);
    }

    private void checkAndHandleLang(Attributes attributes) throws SAXException {
        int n = attributes.getIndex(XML_LANG);
        if (n == -1) {
            return;
        }
        this.initialiseLang(attributes.getValue(n));
        if (this._currentLang == null) {
            this._slang.addNewScopedElement(NULL);
        } else {
            this._slang.addNewScopedElement(this._currentLang);
        }
    }

    private void initialiseLang(String string) throws SAXException {
        this._currentLang = string.isEmpty() ? null : string;
    }

    private void initialiseBaseURI(String string) throws SAXException {
        if (string.contains(" ")) {
            this.warning("Base uri '" + string + "' contains a space.");
            string = string.replaceAll(" ", "+");
        }
        try {
            this._currentBase = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.fatalError(new SAXException(uRISyntaxException));
        }
        if (!this._currentBase.isAbsolute()) {
            this.fatalError(new SAXException(new RDFXMLParseException("Cannot have relative xml:base value: '" + string + "'.")));
        }
    }

    private void initialiseCurrentResource(Resource resource, Attributes attributes) throws SAXException {
        this._currentLi = 0;
        this._currentS = null;
        ResourceDescription resourceDescription = new ResourceDescription();
        if (!resource.equals(RDF.DESCRIPTION)) {
            resourceDescription.addEdge(RDF.TYPE, resource);
        }
        this.checkAndHandleBaseURI(attributes);
        this.checkAndHandleLang(attributes);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node[] nodeArray = this.handleSubjectAttributePair(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
            if (nodeArray == null) continue;
            resourceDescription.addEdge(nodeArray);
        }
        if (this._currentS == null) {
            this._currentS = this.generateBNode();
        }
        this._fifoS.add(this._currentS);
        for (Node[] nodeArray : resourceDescription.getEdges()) {
            this.handleStatement(this._currentS, nodeArray[0], nodeArray[1]);
        }
    }

    private Node[] handleSubjectAttributePair(String string, String string2, String string3, String string4) throws SAXException {
        Resource resource;
        if (string == null || string.equals(NULL)) {
            if (RDF_SUBJ_ATTR_NAMES_TS.contains(string2)) {
                this.warning("Unqualified use of RDF name '" + string2 + "' is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else {
                this.error("Unqualified attribute name '" + string2 + "' found.");
                resource = new Resource(this.resolveFullURI(string2, false));
            }
        } else {
            resource = new Resource(string + string2);
        }
        if (resource.equals(RDF.ABOUT)) {
            if (this._currentS != null) {
                this.fatalError("rdf:about used for resource already identified as '" + this._currentS + "'.");
            }
            this._currentS = new Resource(this.resolveFullURI(string4, false));
            return null;
        }
        if (resource.equals(RDF.ID)) {
            if (this._currentS != null) {
                this.fatalError("rdf:ID used for resource already identified as '" + this._currentS + "'.");
            }
            this._currentS = new Resource(this.resolveFullURI(string4, true));
            return null;
        }
        if (resource.equals(RDF.NODEID)) {
            if (this._currentS != null) {
                this.fatalError("rdf:nodeID used for resource already identified as '" + this._currentS + "'.");
            }
            this._currentS = this.generateBNode(string4);
            return null;
        }
        if (resource.equals(RDF.TYPE)) {
            return new Node[]{RDF.TYPE, new Resource(string4)};
        }
        if (string3.equals(XML_BASE)) {
            return null;
        }
        if (string3.equals(XML_LANG)) {
            return null;
        }
        return new Node[]{resource, this.createLiteral(string4)};
    }

    private String resolveFullURI(String string, boolean bl) throws SAXException {
        URI uRI = null;
        int n = string.length();
        if (n != (string = string.trim()).length()) {
            this.warning("Leading or trailing whitespace in id " + string + ".");
        }
        if (string.contains(" ")) {
            this.warning("ID " + string + " contains a space.");
            string = string.replaceAll(" ", "+");
        }
        if (bl) {
            if (!this._ids.add(string)) {
                this.warning("Duplicate value '" + string + "' for rdf:ID attribute.");
            }
            if (!Pattern.matches("(?:(?:_|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5]))))(?:[-._]|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5])))|(?:[0-9]|\\xD9[\\xA0-\\xA9]|\\xDB[\\xB0-\\xB9]|\\xE0(?:\\xA5[\\xA6-\\xAF]|\\xA7[\\xA6-\\xAF]|\\xA9[\\xA6-\\xAF]|\\xAB[\\xA6-\\xAF]|\\xAD[\\xA6-\\xAF]|\\xAF[\\xA7-\\xAF]|\\xB1[\\xA6-\\xAF]|\\xB3[\\xA6-\\xAF]|\\xB5[\\xA6-\\xAF]|\\xB9[\\x90-\\x99]|\\xBB[\\x90-\\x99]|\\xBC[\\xA0-\\xA9]))|(?:\\xCC[\\x80-\\xBF]|\\xCD[\\x80-\\x85\\xA0\\xA1]|\\xD2[\\x83-\\x86]|\\xD6[\\x91-\\xA1\\xA3-\\xB9\\xBB-\\xBD\\xBF]|\\xD7[\\x81\\x82\\x84]|\\xD9[\\x8B-\\x92\\xB0]|\\xDB[\\x96-\\xA4\\xA7\\xA8\\xAA-\\xAD]|\\xE0(?:\\xA4[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA5[\\x80-\\x8D\\x91-\\x94\\xA2\\xA3]|\\xA6[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA7[\\x80-\\x84\\x87\\x88\\x8B-\\x8D\\x97\\xA2\\xA3]|\\xA8[\\x82\\xBC\\xBE\\xBF]|\\xA9[\\x80-\\x82\\x87\\x88\\x8B-\\x8D\\xB0\\xB1]|\\xAA[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAB[\\x80-\\x85\\x87-\\x89\\x8B-\\x8D]|\\xAC[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAD[\\x80-\\x83\\x87\\x88\\x8B-\\x8D\\x96\\x97]|\\xAE[\\x82\\x83\\xBE\\xBF]|\\xAF[\\x80-\\x82\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB0[\\x81-\\x83\\xBE\\xBF]|\\xB1[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB2[\\x82\\x83\\xBE\\xBF]|\\xB3[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB4[\\x82\\x83\\xBE\\xBF]|\\xB5[\\x80-\\x83\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB8[\\xB1\\xB4-\\xBA]|\\xB9[\\x87-\\x8E]|\\xBA[\\xB1\\xB4-\\xB9\\xBB\\xBC]|\\xBB[\\x88-\\x8D]|\\xBC[\\x98\\x99\\xB5\\xB7\\xB9\\xBE\\xBF]|\\xBD[\\xB1-\\xBF]|\\xBE[\\x80-\\x84\\x86-\\x8B\\x90-\\x95\\x97\\x99-\\xAD\\xB1-\\xB7\\xB9])|\\xE2\\x83[\\x90-\\x9C\\xA1]|\\xE3(?:\\x80[\\xAA-\\xAF]|\\x82[\\x99\\x9A]))|(?:\\xC2\\xB7|\\xCB[\\x90\\x91]|\\xCE\\x87|\\xD9\\x80|\\xE0(?:\\xB9\\x86|\\xBB\\x86)|\\xE3(?:\\x80[\\x85\\xB1-\\xB5]|\\x82[\\x9D\\x9E]|\\x83[\\xBC-\\xBE])))*)", string)) {
                this.warning("ID value '" + string + "' is not a valid XML NCName.");
            }
        }
        try {
            uRI = bl ? new URI("#" + string) : new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.fatalError(new SAXException(uRISyntaxException));
        }
        if (uRI.isAbsolute()) {
            if (bl) {
                this.error("Absolute URI provided for rdf:ID. Not resolving against base URI.");
            }
            return string;
        }
        if (string.isEmpty()) {
            if (this._currentBase.getFragment() != null) {
                return this.removeFragment(this._currentBase);
            }
            return this._currentBase.toString();
        }
        if (!(this._currentBase.getPath() != null && this._currentBase.getPath().length() != 0 || this._currentBase.toString().endsWith("/"))) {
            try {
                return new URL(this._currentBase.toURL(), string).toString();
            }
            catch (MalformedURLException malformedURLException) {
                this.error("MalformedURLException resolving base:" + this._currentBase + " id: " + string);
            }
        }
        return this._currentBase.resolve(uRI).toString();
    }

    private String removeFragment(URI uRI) throws SAXException {
        try {
            return new URI(uRI.getScheme().toLowerCase(), uRI.getUserInfo(), uRI.getHost().toLowerCase(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), null).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.error("URISyntaxException removing fragment from base:" + uRI);
            return uRI.toString();
        }
    }

    private Literal createLiteral(String string) {
        Literal literal;
        if (this._datatype != null) {
            literal = new Literal(NxParser.escapeForNx(string), this._datatype);
            this._datatype = null;
        } else {
            literal = this._currentLang != null ? new Literal(NxParser.escapeForNx(string), this._currentLang) : new Literal(NxParser.escapeForNx(string));
        }
        return literal;
    }

    private void initialiseCurrentProperty(Resource resource, Attributes attributes) throws SAXException {
        this._currentP = resource;
        if (this._currentP.equals(RDF.LI)) {
            ++this._currentLi;
            this._li.put(this._depth, this._currentLi);
            this._currentP = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this._currentLi);
        }
        ++this._depth;
        this.checkAndHandleBaseURI(attributes);
        this.checkAndHandleLang(attributes);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.handlePropertyAttributePair(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
        }
        if (this._currentPRD != null) {
            Node node = this._currentPRD.getIdentifier();
            if (node == null) {
                node = this.generateBNode();
            }
            for (Node[] nodeArray : this._currentPRD.getEdges()) {
                this.handleStatement(node, nodeArray[0], nodeArray[1]);
            }
            this._currentPRD = null;
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this._state.equals(State.PTL_XML)) {
            this.handleXMLLiteralPrefixMapping(string, string2);
        }
    }

    private void handleXMLLiteralPrefixMapping(String string, String string2) {
        this._xmllPrefixes.put(string, string2);
        if (this._prefixDefinition == null) {
            this._prefixDefinition = new StringBuffer();
        }
        this._prefixDefinition.append(" " + this.createPrefixDefinition(string, string2));
    }

    private String createPrefixDefinition(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return "xmlns=\"" + string2 + "\"";
        }
        return "xmlns:" + string + "=\"" + string2 + "\"";
    }

    private String getPrefix(String string, String string2) {
        if (string.length() == string2.length()) {
            return NULL;
        }
        return string.substring(0, string2.length() - (string.length() + 1));
    }

    private void checkXMLLiteralPrefix(String string, String string2, String string3) {
        if (string.equals(NULL)) {
            return;
        }
        String string4 = this.getPrefix(string3, string2);
        if (this._xmllPrefixes.get(string4) == null) {
            this.handleXMLLiteralPrefixMapping(string4, string);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this._state.equals(State.PTL_XML)) {
            this._xmllPrefixes.remove(string);
        }
    }

    private void handlePropertyAttributePair(String string, String string2, String string3, String string4) throws SAXException {
        Resource resource;
        if (string == null || string.equals(NULL)) {
            if (RDF_PROP_ATTR_NAMES_TS.contains(string2)) {
                this.warning("Unqualified use of RDF name " + string2 + " is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else {
                this.error("Unqualified attribute name " + string2 + " found.");
                resource = new Resource(this.resolveFullURI(string2, false));
            }
        } else {
            resource = new Resource(string + string2);
        }
        if (resource.equals(RDF.RESOURCE)) {
            if (this._currentPRD != null && this._currentPRD.getIdentifier() != null) {
                this.fatalError("Cannot have more than one rdf:resource/rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:resource attached as attributes to a property.");
            }
            Resource resource2 = new Resource(this.resolveFullURI(string4, false));
            this.handleStatement(this._currentS, this._currentP, resource2);
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription(resource2);
            } else {
                this._currentPRD.setIdentifier(resource2);
            }
            this._state = State.CP;
        } else if (resource.equals(RDF.NODEID)) {
            if (this._currentPRD != null && this._currentPRD.getIdentifier() != null) {
                this.fatalError("Cannot have more than one rdf:resource/rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:nodeID attached as attributes to a property.");
            }
            BNode bNode = this.generateBNode(string4);
            this.handleStatement(this._currentS, this._currentP, bNode);
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription(bNode);
            } else {
                this._currentPRD.setIdentifier(bNode);
            }
            this._state = State.CP;
        } else if (resource.equals(RDF.TYPE)) {
            if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:type attached as attributes to a property.");
            }
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription();
            }
            this._currentPRD.addEdge(RDF.TYPE, new Resource(string4));
            this._state = State.CP;
        } else if (!(string3.equals(XML_BASE) || string3.equals(XML_LANG) || string3.equals(XML_SPACE) || string3.equals(XML_ID))) {
            if (string3.startsWith(XML_PREFIX)) {
                this.warning("Unrecognised xml qname " + string3 + ".");
            } else if (string3.startsWith(XML_PREFIX)) {
                this.warning("Unrecognised xml qname " + string3 + ".");
            } else if (resource.equals(RDF.DATATYPE)) {
                if (this._state.equals(State.CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:resource attached as attributes to a property.");
                } else if (this._state.equals(State.PTC_OR_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Collection' attached as attributes to a property.");
                } else if (this._state.equals(State.PTL_XML)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Literal' attached as attributes to a property.");
                } else if (this._state.equals(State.PTR_OP_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Resource' attached as attributes to a property.");
                }
                this._datatype = new Resource(this.resolveFullURI(string4, false));
                this._state = State.T_CP;
            } else if (resource.equals(RDF.PARSETYPE)) {
                if (string4.equals("Collection")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTL_XML)) {
                        this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTR_OP_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:parseType='Collection' attached as attributes to a property.");
                    }
                    this._state = State.PTC_OR_CP;
                } else if (string4.equals("Literal")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTC_OR_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTR_OP_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:parseType='Literal' attached as attributes to a property.");
                    }
                    this._state = State.PTL_XML;
                    this._sptlp = this._currentP;
                    this._sptldepth = 0;
                    this._xmllPrefixes = new HashMap();
                    this._currentL = new StringBuffer();
                } else if (string4.equals("Resource")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTC_OR_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTL_XML)) {
                        this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:parseType='Resource' attached as attributes to a property.");
                    }
                    this._currentL = null;
                    this._sptr.add(this._depth);
                    this._state = State.PTR_OP_CP;
                }
            } else if (resource.equals(RDF.ID)) {
                this._currentReify = new Resource(this.resolveFullURI(string4, true));
            } else {
                if (this._state.equals(State.T_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and " + string3 + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTC_OR_CP)) {
                    this.fatalError("Cannot have both rdf:parseType='Collection' and " + string3 + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTL_XML)) {
                    this.fatalError("Cannot have both rdf:parseType='Literal' and " + string3 + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTR_OP_CP)) {
                    this.fatalError("Cannot have both rdf:parseType='Resource' and " + string3 + " attached as attributes to a property.");
                }
                if (this._currentPRD == null) {
                    this._currentPRD = new ResourceDescription();
                }
                this._currentPRD.addEdge(resource, this.createLiteral(string4));
                this._state = State.CP;
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        boolean bl;
        Resource resource = new Resource(string + string2);
        URI uRI = this._sbq.decrementScope();
        if (uRI != null) {
            this._currentBase = uRI;
        }
        boolean bl2 = this._sptr.remove(this._depth);
        boolean bl3 = bl = this._sptldepth == 0 && this._sptlp != null && this._sptlp.equals(resource);
        if (!resource.equals(RDF.RDF) && !this._state.equals(State.OR)) {
            if (this._state.equals(State.CR_OP)) {
                this._fifoS.remove(this._fifoS.size() - 1);
                this._li.remove(this._depth);
                if (bl2) {
                    this._currentS = this._fifoS.get(this._fifoS.size() - 1);
                    object = this._li.get(this._depth - 1);
                    if (object != null) {
                        this._currentLi = (Integer)object;
                    }
                    --this._depth;
                } else if (this._depth > 0) {
                    this._currentS = this._fifoS.get(this._fifoS.size() - 1);
                    object = this._li.get(this._depth - 1);
                    if (object != null) {
                        this._currentLi = (Integer)object;
                    }
                    this._state = State.CP;
                    Node node = this._coll.get(this._depth);
                    if (node != null) {
                        this._currentColl = node;
                        this._state = State.PTC_OR_CP;
                    }
                } else {
                    this._state = State.START;
                }
            } else if (this._state.equals(State.T_CP_OR) || this._state.equals(State.T_CP)) {
                object = NULL;
                if (this._currentL != null) {
                    object = this._currentL.toString();
                }
                Literal literal = this.createLiteral((String)object);
                this.handleStatement(this._currentS, this._currentP, literal);
                this._currentL = null;
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.CP)) {
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this._coll.remove(this._depth);
                if (this._currentColl != null) {
                    this.handleStatement(this._currentColl, RDF.REST, RDF.NIL);
                    this._currentColl = null;
                } else {
                    this.handleStatement(this._currentS, this._currentP, RDF.NIL);
                }
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.PTL_XML)) {
                if (bl) {
                    object = NULL;
                    this._state = State.CR_OP;
                    if (this._currentL != null) {
                        object = this._currentL.toString().trim();
                    }
                    this._datatype = RDF.XMLLITERAL;
                    Literal literal = this.createLiteral((String)object);
                    this.handleStatement(this._currentS, this._currentP, literal);
                    this._currentL = null;
                    this._sptldepth = 0;
                    this._sptlp = null;
                    --this._depth;
                } else {
                    if (resource.equals(this._sptlp)) {
                        --this._sptldepth;
                    }
                    this.handleParseTypeLiteralEndElement(string, string2, string3);
                }
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.handleStatement(this._currentS, this._currentP, this.generateBNode());
                --this._depth;
                this._state = State.CR_OP;
            }
        }
        if ((object = this._slang.decrementScope()) != null) {
            this._currentLang = ((String)object).equals(NULL) ? null : object;
        }
    }

    private void handleParseTypeLiteralEndElement(String string, String string2, String string3) {
        this._currentL.append("</" + string3 + ">");
    }

    private BNode generateBNode() {
        ++this._bnode;
        if (this._skolemise) {
            return new BNode(this._escapedDocURI + "xx" + BNODE_PREFIX + (this._bnode - 1));
        }
        return new BNode(BNODE_PREFIX + (this._bnode - 1));
    }

    private BNode generateBNode(String string) throws SAXException {
        int n = string.length();
        if (n != (string = string.trim()).length()) {
            this.warning("Leading or trailing whitespace in rdf:nodeID " + string + ".");
        }
        if (!Pattern.matches("(?:(?:_|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5]))))(?:[-._]|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5])))|(?:[0-9]|\\xD9[\\xA0-\\xA9]|\\xDB[\\xB0-\\xB9]|\\xE0(?:\\xA5[\\xA6-\\xAF]|\\xA7[\\xA6-\\xAF]|\\xA9[\\xA6-\\xAF]|\\xAB[\\xA6-\\xAF]|\\xAD[\\xA6-\\xAF]|\\xAF[\\xA7-\\xAF]|\\xB1[\\xA6-\\xAF]|\\xB3[\\xA6-\\xAF]|\\xB5[\\xA6-\\xAF]|\\xB9[\\x90-\\x99]|\\xBB[\\x90-\\x99]|\\xBC[\\xA0-\\xA9]))|(?:\\xCC[\\x80-\\xBF]|\\xCD[\\x80-\\x85\\xA0\\xA1]|\\xD2[\\x83-\\x86]|\\xD6[\\x91-\\xA1\\xA3-\\xB9\\xBB-\\xBD\\xBF]|\\xD7[\\x81\\x82\\x84]|\\xD9[\\x8B-\\x92\\xB0]|\\xDB[\\x96-\\xA4\\xA7\\xA8\\xAA-\\xAD]|\\xE0(?:\\xA4[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA5[\\x80-\\x8D\\x91-\\x94\\xA2\\xA3]|\\xA6[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA7[\\x80-\\x84\\x87\\x88\\x8B-\\x8D\\x97\\xA2\\xA3]|\\xA8[\\x82\\xBC\\xBE\\xBF]|\\xA9[\\x80-\\x82\\x87\\x88\\x8B-\\x8D\\xB0\\xB1]|\\xAA[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAB[\\x80-\\x85\\x87-\\x89\\x8B-\\x8D]|\\xAC[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAD[\\x80-\\x83\\x87\\x88\\x8B-\\x8D\\x96\\x97]|\\xAE[\\x82\\x83\\xBE\\xBF]|\\xAF[\\x80-\\x82\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB0[\\x81-\\x83\\xBE\\xBF]|\\xB1[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB2[\\x82\\x83\\xBE\\xBF]|\\xB3[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB4[\\x82\\x83\\xBE\\xBF]|\\xB5[\\x80-\\x83\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB8[\\xB1\\xB4-\\xBA]|\\xB9[\\x87-\\x8E]|\\xBA[\\xB1\\xB4-\\xB9\\xBB\\xBC]|\\xBB[\\x88-\\x8D]|\\xBC[\\x98\\x99\\xB5\\xB7\\xB9\\xBE\\xBF]|\\xBD[\\xB1-\\xBF]|\\xBE[\\x80-\\x84\\x86-\\x8B\\x90-\\x95\\x97\\x99-\\xAD\\xB1-\\xB7\\xB9])|\\xE2\\x83[\\x90-\\x9C\\xA1]|\\xE3(?:\\x80[\\xAA-\\xAF]|\\x82[\\x99\\x9A]))|(?:\\xC2\\xB7|\\xCB[\\x90\\x91]|\\xCE\\x87|\\xD9\\x80|\\xE0(?:\\xB9\\x86|\\xBB\\x86)|\\xE3(?:\\x80[\\x85\\xB1-\\xB5]|\\x82[\\x9D\\x9E]|\\x83[\\xBC-\\xBE])))*)", string)) {
            this.warning("nodeID value '" + string + "' is not a valid XML NCName.");
        }
        string = BNode.escapeForBNode(string);
        if (this._skolemise) {
            return new BNode(this._escapedDocURI + "xx" + string);
        }
        return new BNode(string);
    }

    private void warning(String string) throws SAXException {
        SAXException sAXException = new SAXException(new RDFXMLParseException("WARNING: " + string + " " + this.getLocation()));
        this.warning(sAXException);
    }

    private void error(String string) throws SAXException {
        SAXException sAXException = new SAXException(new RDFXMLParseException("ERROR: " + string + " " + this.getLocation()));
        this.error(sAXException);
    }

    private void fatalError(String string) throws SAXException {
        SAXException sAXException = new SAXException(new RDFXMLParseException("FATAL ERROR: " + string + " " + this.getLocation()));
        this.fatalError(sAXException);
    }

    public void warning(SAXException sAXException) throws SAXException {
        _log.warning(sAXException.getMessage());
        if (this._strict) {
            throw sAXException;
        }
    }

    public void error(SAXException sAXException) throws SAXException {
        _log.warning(sAXException.getMessage());
        if (this._strict) {
            throw sAXException;
        }
    }

    public void fatalError(SAXException sAXException) throws SAXException {
        _log.severe(sAXException.getMessage());
        throw sAXException;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        String string = new String(cArray2);
        if (this._state.expectText()) {
            if (this._currentL == null) {
                this._currentL = new StringBuffer();
            }
            this._currentL.append(string);
        }
    }

    private boolean nodeIsAllowed(String string, Resource resource) throws SAXException {
        if (NOT_ALLOWED_NODE_TS.contains(resource)) {
            this.error("Attribute '" + string + "' not allowed to be used as a node element.");
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        String string = new String(cArray2);
        boolean bl = string.trim().equals(NULL);
        if (bl) {
            this.ignorableWhitespace(cArray, n, n2);
            return;
        }
        if (this._state.expectText()) {
            if (this._currentL == null) {
                this._currentL = new StringBuffer();
            }
            for (int i = n; i < n2 + n; ++i) {
                char c = cArray[i];
                if (this._state.equals(State.PTL_XML)) {
                    if (c == '\"') {
                        this._currentL.append("&quot;");
                        continue;
                    }
                    if (c == '&') {
                        this._currentL.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        this._currentL.append("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        this._currentL.append("&gt;");
                        continue;
                    }
                    int n3 = 0xFFFF & c;
                    if (n3 < 160) {
                        this._currentL.append(c);
                        continue;
                    }
                    this._currentL.append("&#");
                    this._currentL.append(new Integer(n3).toString());
                    this._currentL.append(';');
                    continue;
                }
                this._currentL.append(c);
            }
            if (this._state.equals(State.T_CP_OR)) {
                this._state = State.T_CP;
            }
        } else {
            this.fatalError("Dangling text '" + string + "' found outside of enclosing property tags.");
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return null;
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._loc = locator;
    }

    private String getLocation() {
        if (this._loc != null) {
            return "Line " + this._loc.getLineNumber() + " column " + this._loc.getColumnNumber() + ".";
        }
        return NULL;
    }

    private void handleStatement(Node ... nodeArray) {
        this.processStatement(nodeArray);
        if (this._currentReify != null) {
            this.processStatement(this._currentReify, RDF.TYPE, RDF.STATEMENT);
            this.processStatement(this._currentReify, RDF.SUBJECT, nodeArray[0]);
            this.processStatement(this._currentReify, RDF.PREDICATE, nodeArray[1]);
            this.processStatement(this._currentReify, RDF.OBJECT, nodeArray[2]);
        }
    }

    private void processStatement(Node ... nodeArray) {
        if (this._con != null) {
            this._c.processStatement(new Node[]{nodeArray[0], nodeArray[1], nodeArray[2], this._con});
        } else {
            this._c.processStatement(nodeArray);
        }
    }

    public static class ScopedThing<E> {
        private LinkedList<Integer> _skip = new LinkedList();
        private LinkedList<E> _scoped = new LinkedList();
        private int _currentSkip = -1;
        private E _current = null;
        private E _global;

        public ScopedThing() {
            this(null);
        }

        public boolean inScope(E e) {
            if (this._current != null && this._current.equals(e)) {
                return true;
            }
            if (this._global != null && this._global.equals(e)) {
                return true;
            }
            return this._scoped.contains(e);
        }

        public ScopedThing(E e) {
            this._global = e;
        }

        public void incrementScope() {
            if (this._currentSkip != -1) {
                ++this._currentSkip;
            }
        }

        public E decrementScope() {
            if (this._currentSkip == -1) {
                return null;
            }
            --this._currentSkip;
            if (this._currentSkip == 0) {
                if (this._skip.size() > 0) {
                    this._currentSkip = this._skip.removeLast();
                    this._current = this._scoped.removeLast();
                    return this._current;
                }
                this._currentSkip = -1;
                return this._global;
            }
            return null;
        }

        public void addNewScopedElement(E e) {
            if (this._currentSkip != -1) {
                this._skip.add(this._currentSkip);
                this._scoped.add(this._current);
            }
            this._currentSkip = 0;
            this._current = e;
        }

        public void setCurrent(E e) {
            this._current = e;
        }
    }

    public static class RDFXMLParseException
    extends ParseException {
        private static final long serialVersionUID = 1L;

        public RDFXMLParseException() {
        }

        public RDFXMLParseException(String string) {
            super(string);
        }
    }

    public static class ResourceDescription {
        private Node _id = null;
        private ArrayList<Node[]> _edges = new ArrayList();

        public ResourceDescription() {
        }

        public ResourceDescription(Node node) {
            this._id = node;
        }

        public void setIdentifier(Node node) {
            this._id = node;
        }

        public Node getIdentifier() {
            return this._id;
        }

        public void addEdge(Node ... nodeArray) {
            this._edges.add(nodeArray);
        }

        public ArrayList<Node[]> getEdges() {
            return this._edges;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (Node[] nodeArray : this._edges) {
                stringBuffer.append(this._id.toN3() + " " + Nodes.toN3(nodeArray) + "\n");
            }
            return stringBuffer.toString();
        }
    }

    private static enum State implements Comparable<State>
    {
        START,
        OR,
        CR_OP,
        T_CP_OR,
        CP,
        T_CP,
        PTC_OR_CP,
        PTL_XML,
        PTR_OP_CP;


        public boolean expectCloseProperty() {
            return this.equals(T_CP_OR) || this.equals(CP) || this.equals(T_CP) || this.equals(PTC_OR_CP) || this.equals(PTL_XML);
        }

        public boolean expectCloseResource() {
            return this.equals(CR_OP) || this.equals(PTL_XML);
        }

        public boolean expectText() {
            return this.equals(T_CP_OR) || this.equals(T_CP) || this.equals(PTL_XML);
        }

        public boolean expectOpenResource() {
            return this.equals(START) || this.equals(OR) || this.equals(T_CP_OR) || this.equals(PTC_OR_CP) || this.equals(PTL_XML);
        }

        public boolean expectOpenProperty() {
            return this.equals(CR_OP) || this.equals(PTR_OP_CP) || this.equals(PTL_XML);
        }

        public boolean equals(State state) {
            if (state == null) {
                return false;
            }
            return state.ordinal() == this.ordinal();
        }
    }
}

