/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars2.rdfxml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.util.CallbackBlockingQueue;
import org.semanticweb.yars2.rdfxml.ParserThread;
import org.semanticweb.yars2.rdfxml.RDFXMLParserBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RDFXMLParser
implements Iterator<Node[]> {
    private BlockingQueue<Node[]> _q = null;
    private boolean _done = false;
    private Exception _e = null;
    private ParserThread _pt = null;
    private Node[] _current = null;
    private Resource _con = null;
    public static final int DEFAULT_BUFFER = 1000;
    public static final int TIME_OUT = 1000;
    private SAXParser _parser;

    public RDFXMLParser(InputStream inputStream, String string) throws ParseException, IOException {
        this(inputStream, false, true, string, 1000);
    }

    public RDFXMLParser(InputStream inputStream, boolean bl, boolean bl2, String string) throws ParseException, IOException {
        this(inputStream, bl, bl2, string, 1000);
    }

    public RDFXMLParser(InputStream inputStream, boolean bl, boolean bl2, String string, int n) throws ParseException, IOException {
        Object object = SAXParserFactory.newInstance();
        ((SAXParserFactory)object).setNamespaceAware(true);
        ((SAXParserFactory)object).setValidating(false);
        try {
            this._parser = ((SAXParserFactory)object).newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        try {
            this._q = new ArrayBlockingQueue<Node[]>(n);
            object = new CallbackBlockingQueue(this._q);
            this._pt = new ParserThread(this._parser, inputStream, new RDFXMLParserBase(string, (Callback)object, bl2), this._q);
            this._pt.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public RDFXMLParser(InputStream inputStream, boolean bl, boolean bl2, String string, Callback callback) throws ParseException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        try {
            this._parser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(bl);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new RDFXMLParserBase(string, callback, bl2));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public RDFXMLParser(InputStream inputStream, boolean bl, boolean bl2, String string, Callback callback, Resource resource) throws ParseException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        try {
            this._parser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(bl);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new RDFXMLParserBase(string, callback, bl2, resource));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Resource getContext() {
        return this._con;
    }

    @Override
    public boolean hasNext() {
        if (this._q == null) {
            return false;
        }
        if (this._done) {
            return false;
        }
        if (this._current != null) {
            if (this._current.length == 0) {
                this._done = true;
                this._e = this._pt.getException();
                return false;
            }
            return true;
        }
        if (this._q.size() > 0) {
            this._current = (Node[])this._q.poll();
            return this.hasNext();
        }
        try {
            this._current = this._q.poll(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this._done = true;
            return false;
        }
        return this.hasNext();
    }

    @Override
    public Node[] next() {
        if (this._current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node[] nodeArray = new Node[this._current.length];
        System.arraycopy(this._current, 0, nodeArray, 0, this._current.length);
        this._current = null;
        return nodeArray;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuccess() {
        return this._e == null;
    }

    public Exception getException() {
        return this._e;
    }

    public static void main(String[] stringArray) throws FileNotFoundException, ParseException, IOException, URISyntaxException {
        URI uRI = new URI("http://blah.org/A_%28Secret%29.xml#blah");
        System.out.println(uRI);
        String string = uRI.getPath();
        String string2 = uRI.getRawPath();
        URI uRI2 = new URI(uRI.getScheme().toLowerCase(), uRI.getUserInfo(), uRI.getHost().toLowerCase(), uRI.getPort(), string, uRI.getQuery(), null);
        System.out.println(uRI2.toASCIIString());
        URI uRI3 = new URI(uRI.getScheme().toLowerCase(), uRI.getUserInfo(), uRI.getHost().toLowerCase(), uRI.getPort(), string2, uRI.getQuery(), null);
        System.out.println(uRI3);
    }
}

