/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars2.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars2.rdfxml.RDFXMLParserBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserThread
extends Thread {
    private static Logger _log = Logger.getLogger(ParserThread.class.getName());
    private SAXParser _parser;
    private InputStream _in;
    private RDFXMLParserBase _rxpb;
    private Exception _e = null;
    private final BlockingQueue<Node[]> _q;

    public ParserThread(SAXParser sAXParser, InputStream inputStream, RDFXMLParserBase rDFXMLParserBase, BlockingQueue<Node[]> blockingQueue) {
        this._q = blockingQueue;
        this._parser = sAXParser;
        this._in = inputStream;
        this._rxpb = rDFXMLParserBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._parser.parse(this._in, (DefaultHandler)this._rxpb);
        }
        catch (SAXException sAXException) {
            _log.severe(sAXException.getMessage());
            this._e = sAXException;
        }
        catch (IOException iOException) {
            _log.severe(iOException.getMessage());
            this._e = iOException;
        }
        finally {
            try {
                this._q.put(new Node[0]);
            }
            catch (InterruptedException interruptedException) {
                _log.severe(interruptedException.getMessage());
            }
        }
    }

    public Exception getException() {
        return this._e;
    }
}

