/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util.thread;

import java.util.concurrent.BlockingQueue;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.Callback;

public class ConsumerThread
extends Thread {
    int _ticks = Main.TICKS;
    static int _thread_count = 0;
    Callback _cb;
    BlockingQueue<Node[]> _q;
    InterruptedException _e;
    int _eofs = 1;
    int _done = 0;

    public ConsumerThread(Callback callback, BlockingQueue<Node[]> blockingQueue) {
        this(callback, blockingQueue, 1);
    }

    public void setTicks(int n) {
        this._ticks = n;
    }

    public ConsumerThread(Callback callback, BlockingQueue<Node[]> blockingQueue, int n) {
        super(ConsumerThread.class.getName() + _thread_count);
        ++_thread_count;
        this._cb = callback;
        this._q = blockingQueue;
        this._eofs = n;
    }

    @Override
    public void run() {
        int n = 0;
        this._cb.startDocument();
        try {
            while (this._done < this._eofs) {
                Node[] nodeArray;
                if (this._ticks > 0 && ++n % this._ticks == 0) {
                    System.err.println(this.getName() + " done " + n);
                }
                if ((nodeArray = this._q.take()).equals(Nodes.EOM)) {
                    ++this._done;
                    continue;
                }
                this._cb.processStatement(nodeArray);
            }
        }
        catch (InterruptedException interruptedException) {
            this._e = interruptedException;
        }
        this._cb.endDocument();
    }

    public boolean successful() {
        return this._e == null;
    }

    public InterruptedException getException() {
        return this._e;
    }
}

