/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util.thread;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.util.thread.ConsumerThread;
import org.semanticweb.yars.util.thread.ProducerThread;

public class ConsumerProducerThread
extends Thread {
    public static final Node[] EOM = new Node[0];
    public static final int DEFAULT_BUFFER = 500;
    private ConsumerThread _ct;
    private ProducerThread _pt;
    private Exception _e;

    public ConsumerProducerThread(Iterator<Node[]> iterator, Callback callback) {
        this(iterator, callback, 500);
    }

    public ConsumerProducerThread(Iterator<Node[]> iterator, Callback callback, int n) {
        this(iterator, callback, new ArrayBlockingQueue<Node[]>(n));
    }

    public ConsumerProducerThread(Iterator<Node[]> iterator, Callback callback, BlockingQueue<Node[]> blockingQueue) {
        this._ct = new ConsumerThread(callback, blockingQueue);
        this._pt = new ProducerThread(iterator, blockingQueue);
    }

    @Override
    public void run() {
        try {
            this.runUnthreaded();
        }
        catch (Exception exception) {
            this._e = exception;
        }
    }

    public void setTicks(int n) {
        this._ct.setTicks(n);
        this._pt.setTicks(n);
    }

    public boolean successful() {
        return this._e == null;
    }

    public Exception getException() {
        return this._e;
    }

    public void runUnthreaded() throws InterruptedException {
        this._pt.start();
        this._ct.start();
        this._pt.join();
        this._ct.join();
        if (!this._ct.successful()) {
            throw this._ct.getException();
        }
    }
}

