/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;

public class TicksIterator
implements Iterator<Node[]> {
    static final transient Logger DEFAULT_LOG = Logger.getLogger(TicksIterator.class.getName());
    static final String DEFAULT_MESSAGE = "Input ";
    static final Level DEFAULT_LEVEL = Level.INFO;
    final Logger _log;
    final Level _l;
    final Iterator<Node[]> _in;
    final int _ticks;
    final String _message;
    int _count = 0;

    public TicksIterator(Iterator<Node[]> iterator, int n) {
        this(iterator, n, DEFAULT_LOG, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public TicksIterator(Iterator<Node[]> iterator, int n, Logger logger) {
        this(iterator, n, logger, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public TicksIterator(Iterator<Node[]> iterator, int n, Logger logger, Level level) {
        this(iterator, n, logger, level, DEFAULT_MESSAGE);
    }

    public TicksIterator(Iterator<Node[]> iterator, int n, Logger logger, String string) {
        this(iterator, n, logger, DEFAULT_LEVEL, string);
    }

    public TicksIterator(Iterator<Node[]> iterator, int n, Logger logger, Level level, String string) {
        this._in = iterator;
        this._log = logger;
        this._ticks = n;
        this._message = string;
        this._l = level;
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> iterator, int n) {
        return TicksIterator.createTicksIterator(iterator, n, DEFAULT_LOG, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> iterator, int n, Logger logger) {
        return TicksIterator.createTicksIterator(iterator, n, logger, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> iterator, int n, Logger logger, Level level) {
        return TicksIterator.createTicksIterator(iterator, n, logger, level, DEFAULT_MESSAGE);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> iterator, int n, Logger logger, String string) {
        return TicksIterator.createTicksIterator(iterator, n, logger, DEFAULT_LEVEL, string);
    }

    public static Iterator<Node[]> createTicksIterator(Iterator<Node[]> iterator, int n, Logger logger, Level level, String string) {
        if (n > 0) {
            return new TicksIterator(iterator, n, logger, level, string);
        }
        return iterator;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    public int count() {
        return this._count;
    }

    @Override
    public Node[] next() {
        ++this._count;
        if (this._count > 0 && this._count % this._ticks == 0) {
            this._log.log(this._l, this._message + " " + this._count);
        }
        return this._in.next();
    }

    @Override
    public void remove() {
        this._in.remove();
    }
}

