/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class PeekingIterator<T>
implements Iterator<T> {
    T _peek;
    T _next;
    Iterator<T> _it;
    Status _stat;

    public PeekingIterator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public PeekingIterator(Iterator<T> iterator) {
        this._it = iterator;
        this._stat = Status.VIRGINAL;
        this._next = null;
    }

    @Override
    public boolean hasNext() {
        switch (this._stat) {
            case VIRGINAL: {
                return this._it.hasNext();
            }
        }
        return this._stat != Status.FINISHED;
    }

    @Override
    public T next() {
        switch (this._stat) {
            case VIRGINAL: {
                this._stat = Status.RUNNING;
                if (this._it.hasNext()) {
                    T t = this._it.next();
                    if (!this._it.hasNext()) {
                        this._stat = Status.FINISHED;
                    } else {
                        this._peek = this._it.next();
                        if (!this._it.hasNext()) {
                            this._stat = Status.ITERATOR_FINISHED;
                        } else {
                            this._next = this._it.next();
                        }
                    }
                    return t;
                }
                this._stat = Status.FINISHED;
            }
            case FINISHED: {
                throw new NoSuchElementException();
            }
            case ITERATOR_FINISHED: {
                this._stat = Status.FINISHED;
                return this._peek;
            }
        }
        T t = this._peek;
        if (!this._it.hasNext()) {
            this._stat = Status.FINISHED;
        } else {
            this._peek = this._next;
        }
        if (!this._it.hasNext()) {
            this._stat = Status.ITERATOR_FINISHED;
            this._peek = this._next;
            this._next = null;
        } else {
            this._peek = this._next;
            this._next = this._it.next();
        }
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public T peek() {
        switch (this._stat) {
            case VIRGINAL: {
                if (!this._it.hasNext()) {
                    this._stat = Status.FINISHED;
                    return null;
                }
                this._stat = Status.RUNNING;
                this._peek = this._it.next();
                if (!this._it.hasNext()) {
                    this._stat = Status.ITERATOR_FINISHED;
                } else {
                    this._next = this._it.next();
                }
                return this._peek;
            }
            case FINISHED: {
                return null;
            }
        }
        return this._peek;
    }

    public static void main(String[] stringArray) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < 1; ++i) {
            linkedList.add(i);
        }
        PeekingIterator peekingIterator = new PeekingIterator(linkedList.iterator());
        while (peekingIterator.hasNext()) {
            if (Math.random() > 0.5) {
                System.out.println("peek " + peekingIterator.peek());
                continue;
            }
            System.out.println("next " + peekingIterator.next());
        }
        System.out.println("peek " + peekingIterator.peek());
    }

    private static enum Status {
        VIRGINAL,
        RUNNING,
        ITERATOR_FINISHED,
        FINISHED;

    }
}

