/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.yars.util.LRUMapCache;

public class LRUSetCache<E>
extends AbstractSet<E>
implements Set<E> {
    private static final long serialVersionUID = 1L;
    public static int DEFAULT_CACHE_SIZE = 100;
    public static float DEFAULT_LOAD_FACTOR = 0.75f;
    LRUMapCache<E, E> _map;

    public LRUSetCache() {
        this(DEFAULT_CACHE_SIZE, DEFAULT_LOAD_FACTOR);
    }

    public LRUSetCache(int n) {
        this(n, DEFAULT_LOAD_FACTOR);
    }

    public LRUSetCache(int n, float f) {
        this._map = new LRUMapCache(n, f);
    }

    @Override
    public boolean add(E e) {
        return this._map.put(e, e) == null;
    }

    @Override
    public boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this._map.remove(object) != null;
    }

    @Override
    public int size() {
        return this._map.size();
    }
}

