/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.Map;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.util.LRUMapCache;

public class FlyweightNodeIterator
implements Iterator<Node[]> {
    Map<Node, Node> _flyweight;
    Iterator<Node[]> _in;

    public FlyweightNodeIterator(int n, Iterator<Node[]> iterator) {
        this(new LRUMapCache<Node, Node>(n), iterator);
    }

    public FlyweightNodeIterator(Map<Node, Node> map, Iterator<Node[]> iterator) {
        this._flyweight = map;
        this._in = iterator;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    @Override
    public Node[] next() {
        Node[] nodeArray = this._in.next();
        Node[] nodeArray2 = new Node[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray2[i] = this.flyweight(nodeArray[i]);
        }
        return nodeArray2;
    }

    private Node flyweight(Node node) {
        Node node2 = this._flyweight.get(node);
        if (node2 == null) {
            this._flyweight.put(node, node);
            return node;
        }
        return node2;
    }

    @Override
    public void remove() {
        this._in.remove();
    }
}

