/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;

public class CheckSortedIterator
implements Iterator<Node[]> {
    Iterator<Node[]> _in;
    Node[] _old = null;
    Comparator<Node[]> _nc;
    NotSortedException _last = null;
    static transient Logger _log = Logger.getLogger(CheckSortedIterator.class.getName());

    public CheckSortedIterator(Iterator<Node[]> iterator) {
        this(iterator, NodeComparator.NC);
    }

    public CheckSortedIterator(Iterator<Node[]> iterator, Comparator<Node[]> comparator) {
        this._in = iterator;
        this._nc = comparator;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    public NotSortedException getException() {
        return this._last;
    }

    public boolean isOkay() {
        return this._last == null;
    }

    @Override
    public Node[] next() {
        int n;
        Node[] nodeArray = this._in.next();
        if (this._old != null && (n = this._nc.compare(this._old, nodeArray)) > 0 && n != -2147480429) {
            this._last = new NotSortedException(this._old, nodeArray);
            _log.severe(this._last.getMessage());
        }
        this._old = nodeArray;
        return nodeArray;
    }

    @Override
    public void remove() {
        this._in.remove();
    }

    public static void main(String[] stringArray) {
        Node[] nodeArray = new Node[]{new Resource("http://docs.openlinksw.com/virtuoso/creatingtxtidxs.html"), new Resource("http://rdfs.org/sioc/ns#title"), new Literal("Database"), new Resource("http://docs.openlinksw.com/virtuoso/creatingtxtidxs.sioc.rdf")};
        Node[] nodeArray2 = new Node[]{new Resource("http://docs.openlinksw.com/virtuoso/creatingtxtidxs.html"), new Resource("http://rdfs.org/sioc/ns#title"), new Literal("Creating Free Text Indexes"), new Resource("http://docs.openlinksw.com/virtuoso/virtdocs.sioc.rdf")};
        System.err.println(NodeComparator.NC.compare(nodeArray, nodeArray2));
    }

    public static class NotSortedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Node[] _a;
        private Node[] _b;

        public NotSortedException(String string) {
            super(string);
        }

        public NotSortedException(Node[] nodeArray, Node[] nodeArray2) {
            super(NotSortedException.createMessage(nodeArray, nodeArray2));
            this._a = nodeArray;
            this._b = nodeArray2;
        }

        public Node[] getFirstNodes() {
            return this._a;
        }

        public Node[] getSecondNodes() {
            return this._b;
        }

        static String createMessage(Node[] nodeArray, Node[] nodeArray2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#########Not sorted!#########\n");
            stringBuffer.append(" " + Nodes.toN3(nodeArray) + " before\n");
            stringBuffer.append(" " + Nodes.toN3(nodeArray2) + "\n");
            return stringBuffer.toString();
        }
    }
}

