/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;

public class CheckLengthIterator
implements Iterator<Node[]> {
    Iterator<Node[]> _in;
    Node[] _next = null;
    IncorrectLengthException _ile = null;
    short _nxlen = 0;
    long _skip = 0L;
    static transient Logger _log = Logger.getLogger(CheckLengthIterator.class.getName());

    public CheckLengthIterator(Iterator<Node[]> iterator, short s) {
        this._in = iterator;
        this._nxlen = s;
        this.loadNext();
    }

    private void loadNext() {
        this._next = null;
        while (this._in.hasNext() && this._next == null) {
            Node[] nodeArray = this._in.next();
            if (nodeArray.length != this._nxlen) {
                this._ile = new IncorrectLengthException(nodeArray);
                _log.warning(this._ile.getMessage());
                ++this._skip;
                continue;
            }
            this._next = nodeArray;
        }
    }

    public long skipped() {
        return this._skip;
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    public IncorrectLengthException getException() {
        return this._ile;
    }

    public boolean isOkay() {
        return this._ile == null;
    }

    @Override
    public Node[] next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        Node[] nodeArray = this._next;
        this.loadNext();
        return nodeArray;
    }

    @Override
    public void remove() {
        this._in.remove();
    }

    public static class IncorrectLengthException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Node[] _a;

        public IncorrectLengthException(String string) {
            super(string);
        }

        public IncorrectLengthException(Node[] nodeArray) {
            super(IncorrectLengthException.createMessage(nodeArray));
            this._a = nodeArray;
        }

        public Node[] getProblem() {
            return this._a;
        }

        static String createMessage(Node[] nodeArray) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Not correct length!");
            stringBuffer.append(" " + Nodes.toN3(nodeArray) + " ");
            return stringBuffer.toString();
        }
    }
}

