/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.Callback;

public class CallbackTicks
implements Callback {
    static final transient Logger DEFAULT_LOG = Logger.getLogger(CallbackTicks.class.getName());
    static final String DEFAULT_MESSAGE = "Output ";
    static final Level DEFAULT_LEVEL = Level.INFO;
    final Logger _log;
    final Level _l;
    final Callback _cb;
    final int _ticks;
    final String _message;
    int _count = 0;

    public CallbackTicks(Callback callback, int n) {
        this(callback, n, DEFAULT_LOG, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public CallbackTicks(Callback callback, int n, Logger logger) {
        this(callback, n, logger, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public CallbackTicks(Callback callback, int n, Logger logger, Level level) {
        this(callback, n, logger, level, DEFAULT_MESSAGE);
    }

    public CallbackTicks(Callback callback, int n, Logger logger, String string) {
        this(callback, n, logger, DEFAULT_LEVEL, string);
    }

    public CallbackTicks(Callback callback, int n, Logger logger, Level level, String string) {
        this._cb = callback;
        this._log = logger;
        this._ticks = n;
        this._message = string;
        this._l = level;
    }

    public int count() {
        return this._count;
    }

    @Override
    public void endDocument() {
        this._cb.endDocument();
    }

    @Override
    public void processStatement(Node[] nodeArray) {
        ++this._count;
        if (this._count > 0 && this._count % this._ticks == 0) {
            this._log.log(this._l, this._message + " " + this._count);
        }
        this._cb.processStatement(nodeArray);
    }

    @Override
    public void startDocument() {
        this._cb.startDocument();
    }

    public static Callback createCallbackTicks(Callback callback, int n) {
        return CallbackTicks.createCallbackTicks(callback, n, DEFAULT_LOG, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public static Callback createCallbackTicks(Callback callback, int n, Logger logger) {
        return CallbackTicks.createCallbackTicks(callback, n, logger, DEFAULT_LEVEL, DEFAULT_MESSAGE);
    }

    public static Callback createCallbackTicks(Callback callback, int n, Logger logger, Level level) {
        return CallbackTicks.createCallbackTicks(callback, n, logger, level, DEFAULT_MESSAGE);
    }

    public static Callback createCallbackTicks(Callback callback, int n, Logger logger, String string) {
        return CallbackTicks.createCallbackTicks(callback, n, logger, DEFAULT_LEVEL, string);
    }

    public static Callback createCallbackTicks(Callback callback, int n, Logger logger, Level level, String string) {
        if (n > 0) {
            return new CallbackTicks(callback, n, logger, level, string);
        }
        return callback;
    }
}

