/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.Callback;

public class CallbackRDFXMLOutputStream
implements Callback {
    private static Logger _log = Logger.getLogger(CallbackRDFXMLOutputStream.class.getName());
    OutputStream _out;
    long _cnt = 0L;
    long _time;
    long _time1;
    public static final String NEWLINE = System.getProperty("line.separator");

    public CallbackRDFXMLOutputStream(OutputStream outputStream) {
        this._out = outputStream;
    }

    @Override
    public void startDocument() {
        this._time = System.currentTimeMillis();
        try {
            this._out.write("<?xml version='1.0' encoding='utf-8'?>\n\n".getBytes("utf-8"));
            this._out.write("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>\n".getBytes("utf-8"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public synchronized void processStatement(Node[] nodeArray) {
        if (nodeArray.length < 3) {
            _log.warning("nx length has to be at least 3!, dropping");
            return;
        }
        if (!(nodeArray[1] instanceof Resource)) {
            _log.warning("predicate must be resource, is " + nodeArray[1] + ", dropping");
            return;
        }
        String string = nodeArray[1].toString();
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(35);
        if (n > 0) {
            string2 = string.substring(0, n + 1);
            string3 = string.substring(n + 1, string.length());
        } else {
            n = string.lastIndexOf(47);
            if (n > 0) {
                string2 = string.substring(0, n + 1);
                string3 = string.substring(n + 1, string.length());
            }
        }
        if (string2 == null && string3 == null) {
            _log.warning("couldn't separate namespace and localname " + string);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<rdf:Description ");
        if (nodeArray[0] instanceof Resource) {
            stringBuffer.append(" rdf:about='" + nodeArray[0].toString() + "'>");
        } else if (nodeArray[0] instanceof BNode) {
            stringBuffer.append(" rdf:nodeID='" + nodeArray[0].toString() + "'>\n");
        }
        stringBuffer.append("\t<" + string3 + " xmlns='" + string2 + "'");
        if (nodeArray[2] instanceof BNode) {
            stringBuffer.append(" rdf:nodeID='" + nodeArray[2].toString() + "'/>\n");
        } else if (nodeArray[2] instanceof Resource) {
            stringBuffer.append(" rdf:resource='" + CallbackRDFXMLOutputStream.escape(nodeArray[2].toString()) + "'/>\n");
        } else if (nodeArray[2] instanceof Literal) {
            Literal literal = (Literal)nodeArray[2];
            if (literal.getLanguageTag() != null) {
                stringBuffer.append(" xml:lang='" + literal.getLanguageTag() + "'");
            } else if (literal.getDatatype() != null) {
                stringBuffer.append(" rdf:datatype='" + literal.getDatatype().toString() + "'");
            }
            stringBuffer.append(">" + CallbackRDFXMLOutputStream.escape(literal.toString()) + "</" + string3 + ">\n");
        }
        stringBuffer.append("</rdf:Description>\n");
        try {
            this._out.write(stringBuffer.toString().getBytes("utf-8"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        ++this._cnt;
    }

    @Override
    public void endDocument() {
        try {
            this._out.write("</rdf:RDF>\n".getBytes("utf-8"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        try {
            this._out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        this._time1 = System.currentTimeMillis();
    }

    public String toString() {
        return this._cnt + " tuples in " + (this._time1 - this._time) + " ms";
    }

    private static String escape(String string) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\"", "&quot;");
        string2 = string2.replaceAll("'", "&apos;");
        return string2;
    }
}

