/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.tld;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.yars.tld.TldManager;

public class URIHandler
implements Comparator<String> {
    private static final String NO_HOST = "no_host";
    private static final Runtime runtime = Runtime.getRuntime();
    private static final NumberFormat FMT = NumberFormat.getInstance();
    private static Set<String> noTLDSet;
    private static Set<String> tldSet;
    private static Set<String> wildcardTLDSet;
    private static TldManager _tldManager;

    public static void logMem(String string) {
        long l = runtime.maxMemory() - runtime.totalMemory();
        float f = (float)l / 1024.0f;
        float f2 = f / 1024.0f;
        float f3 = f2 / 1024.0f;
        if (f3 >= 1.0f) {
            System.err.println("[MEMLOG] (" + string + ") FreeMemory: " + FMT.format(f3) + " GB");
        } else if (f2 >= 1.0f) {
            System.err.println("[MEMLOG] (" + string + ") FreeMemory: " + FMT.format(f2) + " MB");
        } else {
            System.err.println("[MEMLOG] (" + string + ") FreeMemory: " + FMT.format(f) + " KB");
        }
    }

    private static void parseTLD() throws IOException {
        _tldManager = new TldManager();
    }

    public static String getPLD(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (Exception exception) {
            System.err.println("[ERROR] malformed url " + exception.getMessage());
            return NO_HOST;
        }
        return _tldManager.getPLD(uRI);
    }

    public static String getPLD(URI uRI) {
        String string = _tldManager.getPLD(uRI);
        if (string == null) {
            return NO_HOST;
        }
        return string;
    }

    public static String[] getPathTokens(String string) {
        String[] stringArray;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Object> list = new ArrayList();
        String string2 = "";
        try {
            object = new URI(string.toString());
            string2 = ((URI)object).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                stringArray = new URL(string.toString());
                string2 = stringArray.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        list = Arrays.asList(string2.split("/"));
        for (String string3 : list) {
            object = string3.trim();
            if (((String)object).length() == 0) continue;
            object = ((String)object).replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\"", "").replaceAll(",", "").replaceAll(" ", "_").replaceAll("'", "").replaceAll("%", "").replaceAll("\n", "\\\n");
            object = string2.contains(string3 + "/") ? "/" + (String)object + "/" : (((String)object).contains(".") ? "/" + ((String)object).substring(0, ((String)object).lastIndexOf(".")) : "/" + (String)object);
            if (arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        if (string2.endsWith("/") || string2.trim().length() == 0) {
            // empty if block
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static String[] getPathTokens(URI uRI) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = uRI.getPath();
        if (string == null) {
            string = "";
        }
        for (String string2 : stringArray = string.split("/")) {
            String string3 = string2.trim();
            if (string3.length() == 0) continue;
            string3 = string3.replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\"", "").replaceAll(",", "").replaceAll(" ", "_").replaceAll("'", "").replaceAll("%", "").replaceAll("\n", "\\\n");
            string3 = string.contains(string2 + "/") ? "/" + string3 + "/" : (string3.contains(".") ? "/" + string3.substring(0, string3.lastIndexOf(".")) : "/" + string3);
            if (arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    public static String getFileName(String string) {
        Object object;
        Comparable<URI> comparable;
        String string2 = "";
        try {
            comparable = new URI(string.toString());
            string2 = ((URI)comparable).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                object = new URL(string.toString());
                string2 = ((URL)object).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            return "/NO_FNAME";
        }
        comparable = new File(string2);
        object = ((File)comparable).getName();
        if (((String)object).endsWith("/")) {
            return "/NO_FNAME";
        }
        if (((String)object).contains(".")) {
            object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
        }
        if (((String)(object = ((String)object).replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\"", "").replaceAll(",", "").replaceAll(" ", "_").replaceAll("'", "").replaceAll("%", ""))).trim().length() == 0) {
            return "/NO_FNAME";
        }
        return "/" + (String)object;
    }

    public static String getFileExtension(String string) {
        Comparable<URI> comparable;
        String string2 = "";
        String string3 = "";
        try {
            comparable = new URI(string.toString());
            string3 = ((URI)comparable).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                URL uRL = new URL(string.toString());
                string3 = uRL.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (string3 == null) {
            return ".NOEXT";
        }
        comparable = new File(string3);
        if (((File)comparable).getName().endsWith("/")) {
            return ".NOEXT";
        }
        int n = ((File)comparable).getName().lastIndexOf(".");
        if (n > -1) {
            string2 = ((File)comparable).getName().substring(n).trim();
        }
        if (string2.length() == 0 || string2.contains(",") || string2.contains("}") || string2.contains("/") || string2.contains("{") || string2.contains("=") || string2.contains("'") || string2.contains("(") || string2.contains(")") || string2.contains(" ")) {
            return ".NOEXT";
        }
        return string2.trim().toLowerCase();
    }

    public static String getFileExtension(URI uRI) {
        String string = "";
        String string2 = uRI.getPath();
        if (string2 == null) {
            return ".NOEXT";
        }
        if (string2.endsWith("/")) {
            return ".NOEXT";
        }
        int n = string2.lastIndexOf(".");
        if (n > -1) {
            string = string2.substring(n).trim();
        }
        if (string.length() == 0 || string.length() > 4) {
            return ".NOEXT";
        }
        return string.trim().toLowerCase();
    }

    public static void main(String[] stringArray) throws IOException {
        URIHandler uRIHandler = new URIHandler();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println(URIHandler.getPLD(string.trim()));
        }
    }

    @Override
    public int compare(String string, String string2) {
        System.out.println("compare(" + string + "," + string2 + ")");
        return string.compareTo(string2);
    }

    public static long getFreeMem() {
        return runtime.maxMemory() - runtime.totalMemory();
    }

    public String getDomain(String string) {
        URL uRL;
        try {
            URI uRI = new URI(string.toString());
            uRL = uRI.toURL();
        }
        catch (Exception exception) {
            try {
                uRL = new URL(string.toString());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("[ERROR] malformed url " + malformedURLException.getMessage());
                return "NO_HOST";
            }
        }
        return uRL.getHost();
    }

    static {
        FMT.setMaximumFractionDigits(2);
        FMT.setMinimumFractionDigits(2);
        noTLDSet = new HashSet<String>();
        tldSet = new HashSet<String>();
        wildcardTLDSet = new HashSet<String>();
        try {
            URIHandler.parseTLD();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }
}

