/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.tld;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semanticweb.yars.tld.Tld;

public class TldManager {
    private static Logger _log = Logger.getLogger(TldManager.class.getName());
    HashMap<String, Tld> TLDs = null;

    public TldManager() throws IOException {
        this.read(TldManager.class.getResourceAsStream("tld.dat"));
    }

    void read(InputStream inputStream) throws IOException {
        this.TLDs = new HashMap();
        if (inputStream == null) {
            throw new IOException("input stream is null");
        }
        this.readList(inputStream);
    }

    public String getPLD(URI uRI) {
        try {
            if (uRI.getScheme() == null) {
                _log.info("no scheme: " + uRI);
                return null;
            }
            if (!uRI.getScheme().equalsIgnoreCase("http") && !uRI.getScheme().equalsIgnoreCase("https")) {
                _log.info("scheme not http(s) " + uRI);
                return null;
            }
            String string = uRI.getHost().toLowerCase();
            if (string == null) {
                _log.fine("no host for " + uRI);
                return null;
            }
            String[] stringArray = string.split("\\.");
            if (stringArray.length == 1) {
                _log.info("no TLD " + uRI);
                return string;
            }
            if (stringArray.length == 2) {
                return string;
            }
            String string2 = string.substring(string.lastIndexOf(".") + 1, string.length());
            Tld tld = this.TLDs.get(string2);
            if (tld == null) {
                _log.info("no TLD " + uRI);
                return string;
            }
            if (stringArray.length == 3) {
                if (tld.getHasOneLvlSffxes()) {
                    if (tld.getAddlTwoLvlSffxes().contains(stringArray[1] + "." + stringArray[2])) {
                        return string;
                    }
                    if (tld.getExcptnlThreeLvlDomains().contains(string)) {
                        return string;
                    }
                    return stringArray[1] + "." + stringArray[2];
                }
                if (tld.getHasTwoLvlSffxes()) {
                    if (tld.getExcptnlTwoLvlDomains().contains(stringArray[1] + "." + stringArray[2])) {
                        return stringArray[1] + "." + stringArray[2];
                    }
                    return string;
                }
                if (tld.getAddlTwoLvlSffxes().contains(stringArray[1] + "." + stringArray[2])) {
                    return string;
                }
                if (tld.getExcptnlThreeLvlDomains().contains(string)) {
                    return string;
                }
                _log.info("? TLD " + uRI);
                return string;
            }
            string = stringArray[stringArray.length - 4] + "." + stringArray[stringArray.length - 3] + "." + stringArray[stringArray.length - 2] + "." + stringArray[stringArray.length - 1];
            if ((stringArray = string.split("\\."))[3].equals("us") && stringArray[2].length() == 2 && tld.getAddlTwoLvlSffxes().contains(stringArray[2] + "." + stringArray[3])) {
                return string;
            }
            if (tld.getHasOneLvlSffxes()) {
                if (tld.getAddlThreeLvlSffxes().contains(stringArray[1] + "." + stringArray[2] + "." + stringArray[3])) {
                    return string;
                }
                if (tld.getAddlTwoLvlSffxes().contains(stringArray[2] + "." + stringArray[3])) {
                    return stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
                }
                if (tld.getExcptnlThreeLvlDomains().contains(stringArray[1] + "." + stringArray[2] + "." + stringArray[3])) {
                    return stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
                }
                if (tld.getAddlWildcardThreeLvlSffxes().contains(stringArray[2] + "." + stringArray[3])) {
                    return string;
                }
                return stringArray[2] + "." + stringArray[3];
            }
            if (tld.getHasTwoLvlSffxes()) {
                if (tld.getExcptnlTwoLvlDomains().contains(stringArray[2] + "." + stringArray[3])) {
                    return stringArray[2] + "." + stringArray[3];
                }
                if (tld.getAddlThreeLvlSffxes().contains(stringArray[1] + "." + stringArray[2] + "." + stringArray[3])) {
                    return string;
                }
                if (tld.getExcptnlThreeLvlDomains().contains(stringArray[1] + "." + stringArray[2] + "." + stringArray[3])) {
                    return stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
                }
                if (tld.getAddlWildcardThreeLvlSffxes().contains(stringArray[2] + "." + stringArray[3])) {
                    return string;
                }
                return stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
            }
            if (tld.getAddlTwoLvlSffxes().contains(stringArray[2] + "." + stringArray[3])) {
                return stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
            }
            if (tld.getExcptnlThreeLvlDomains().contains(stringArray[1] + "." + stringArray[2] + "." + stringArray[3])) {
                return stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
            }
        }
        catch (Exception exception) {
            _log.info("error: " + exception.getMessage() + " " + uRI);
            exception.printStackTrace();
        }
        return null;
    }

    private void readList(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Pattern pattern = Pattern.compile("// ([a-z][a-z]+) : .*");
        Tld tld = null;
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (string.trim().isEmpty()) continue;
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(1);
                tld = new Tld(string2);
                this.TLDs.put(string2, tld);
                continue;
            }
            if (tld == null) continue;
            if (string.equals(string2)) {
                tld.setHasOneLvlSffxes();
                continue;
            }
            if (string.equals("*." + string2)) {
                tld.setHasTwoLvlSffxes();
                continue;
            }
            if (string.matches("[a-z0-9-]+\\." + string2)) {
                tld.addAddlTwoLvlSffx(string);
                continue;
            }
            if (string.matches("[a-z0-9-]+\\.[a-z0-9-]+\\." + string2)) {
                tld.addAddlThreeLvlSffx(string);
                continue;
            }
            if (string.matches("![a-z0-9-]+\\." + string2)) {
                tld.addExcptnlTwoLvlDomain(string.substring(1, string.length()));
                continue;
            }
            if (string.matches("\\*\\.[a-z0-9-]+\\." + string2)) {
                tld.addAddlWildcardThreeLvlSffx(string.substring(2, string.length()));
                continue;
            }
            if (!string.matches("![a-z0-9-]+\\.[a-z0-9-]+\\." + string2)) continue;
            tld.addExcptnlThreeLvlDomain(string.substring(1, string.length()));
        }
    }
}

