/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.filter.NodeFilter;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.stats.CountStmtAnalyser;
import org.semanticweb.yars.stats.DistributionAnalyser;
import org.semanticweb.yars.stats.InputAnalyser;
import org.semanticweb.yars.stats.NodeTransformer;
import org.semanticweb.yars.stats.output.ToVoid;

public class VoiD {
    private static final DecimalFormat twoDigit = new DecimalFormat("###,###,###.##");
    private static final Runtime runtime = Runtime.getRuntime();
    private static final NumberFormat FMT = NumberFormat.getInstance();
    InputAnalyser input;
    private String _dataID;

    public VoiD() {
        FMT.setMaximumFractionDigits(2);
        FMT.setMinimumFractionDigits(2);
    }

    public static long getFreeMem() {
        return runtime.maxMemory() - runtime.totalMemory();
    }

    public static void logMem(String string) {
        long l = runtime.maxMemory() - runtime.totalMemory();
        float f = (float)l / 1024.0f;
        float f2 = f / 1024.0f;
        float f3 = f2 / 1024.0f;
        if (f3 >= 1.0f) {
            System.err.println("[MEMLOG] (" + string + ") FreeMemory: " + FMT.format(f3) + " GB");
        } else if (f2 >= 1.0f) {
            System.err.println("[MEMLOG] (" + string + ") FreeMemory: " + FMT.format(f2) + " MB");
        } else {
            System.err.println("[MEMLOG] (" + string + ") FreeMemory: " + FMT.format(f) + " KB");
        }
    }

    public void analyseVoid(InputStream inputStream, String string, OutputStream outputStream) throws IOException, ParseException {
        DistributionAnalyser<String> distributionAnalyser;
        this.input = new InputAnalyser(new NxParser(inputStream));
        this._dataID = string;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{1};
        int[] nArray3 = new int[]{2};
        CountStmtAnalyser countStmtAnalyser = new CountStmtAnalyser(this.input);
        int[] nArray4 = new int[]{1, 2};
        NodeFilter[] nodeFilterArray = new NodeFilter[]{new NodeFilter.EqualsFilter(RDF.TYPE.toString()), new NodeFilter.ClassFilter(Resource.class)};
        NodeTransformer<Node> nodeTransformer = new NodeTransformer<Node>(){

            public Node[] processNode(Node[] nodeArray) {
                Node[] nodeArray2 = new Node[]{nodeArray[1]};
                return nodeArray2;
            }
        };
        DistributionAnalyser<Node> distributionAnalyser2 = new DistributionAnalyser<Node>(countStmtAnalyser, nodeFilterArray, nArray4, nodeTransformer);
        NodeTransformer<String> nodeTransformer2 = new NodeTransformer<String>(){
            private int counter;
            String[] res = new String[]{"-"};

            public String[] processNode(Node[] nodeArray) {
                ++this.counter;
                if (this.counter % 10000 == 0) {
                    VoiD.logMem("lines " + twoDigit.format(this.counter));
                }
                return this.res;
            }
        };
        DistributionAnalyser<String> distributionAnalyser3 = distributionAnalyser = new DistributionAnalyser<String>(distributionAnalyser2, nodeTransformer2);
        while (distributionAnalyser3.hasNext()) {
            distributionAnalyser3.next();
        }
        String string2 = ToVoid.getStmtString(countStmtAnalyser.getStmt());
        String string3 = ToVoid.getClassDist(distributionAnalyser2.getStatsMap());
        String string4 = ToVoid.getDataSetHeader(this._dataID, string2 + string3);
        String string5 = ToVoid.getRDF(string4);
        outputStream.write(string5.getBytes());
        outputStream.close();
    }
}

